/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.hppc;

import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.IntIntMap;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongIntHashMap;
import com.carrotsearch.hppc.LongLongHashMap;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.LongObjectHashMap;
import com.carrotsearch.hppc.LongObjectMap;
import com.carrotsearch.hppc.LongSet;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectLongHashMap;
import com.carrotsearch.hppc.ObjectLongMap;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.IntIntProcedure;
import com.carrotsearch.hppc.procedures.LongIntProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import com.google.common.collect.Iterators;
import java.util.Iterator;

public final class CarrotUtil {
    public static final long LONG_LONG_NO_ENTRY = 0L;
    public static final LongSet EMPTY_LONG_SET = CarrotUtil.immutable((LongSet)new LongHashSet());

    private CarrotUtil() {
        throw new AssertionError();
    }

    public static <T> Iterator<T> iterator(Iterator<ObjectCursor<T>> theIterator) {
        return Iterators.transform(theIterator, theTObjectCursor -> theTObjectCursor.value);
    }

    public static <T> Iterable<T> iterable(ObjectContainer<T> theContainer) {
        return () -> CarrotUtil.iterator(theContainer.iterator());
    }

    public static IntSet intSet() {
        return new IntHashSet();
    }

    public static void addAll(IntSet theContainer, IntContainer theIntsToAdd) {
        theIntsToAdd.forEach(arg_0 -> ((IntSet)theContainer).add(arg_0));
    }

    public static <T> void putAll(IntObjectMap<T> theMap, IntObjectMap<T> theOtherMap) {
        theOtherMap.forEach((arg_0, arg_1) -> theMap.put(arg_0, arg_1));
    }

    public static void putAll(IntIntMap theMap, IntIntMap theOtherMap) {
        theOtherMap.forEach((arg_0, arg_1) -> ((IntIntMap)theMap).put(arg_0, arg_1));
    }

    public static int max(IntContainer theContainer) {
        int aMax = Integer.MIN_VALUE;
        Iterator aIter = theContainer.iterator();
        while (aIter.hasNext()) {
            int aValue = ((IntCursor)aIter.next()).value;
            if (aValue <= aMax) continue;
            aMax = aValue;
        }
        return aMax;
    }

    public static IntIntMap copy(IntIntMap theMap) {
        IntIntHashMap aMap = new IntIntHashMap();
        theMap.forEach((IntIntProcedure)new CopyMapProcedure(aMap));
        return aMap;
    }

    public static IntIntMap[] copy(IntIntMap[] theMap) {
        IntIntMap[] aArray = new IntIntMap[theMap.length];
        for (int i = 0; i < theMap.length; ++i) {
            aArray[i] = CarrotUtil.copy(theMap[i]);
        }
        return aArray;
    }

    public static IntIntHashMap newIntIntOpenHashMap(int ... theKeyOrValue) {
        IntIntHashMap aMap = new IntIntHashMap();
        for (int i = 0; i < theKeyOrValue.length; i += 2) {
            aMap.put(theKeyOrValue[i], theKeyOrValue[i + 1]);
        }
        return aMap;
    }

    public static LongLongHashMap newLongLongOpenHashMap(long ... theKeyOrValue) {
        LongLongHashMap aMap = new LongLongHashMap();
        for (int i = 0; i < theKeyOrValue.length; i += 2) {
            aMap.put(theKeyOrValue[i], theKeyOrValue[i + 1]);
        }
        return aMap;
    }

    public static LongIntHashMap newLongIntOpenHashMap(long ... theKeyOrValue) {
        LongIntHashMap aMap = new LongIntHashMap();
        for (int i = 0; i < theKeyOrValue.length; i += 2) {
            aMap.put(theKeyOrValue[i], (int)theKeyOrValue[i + 1]);
        }
        return aMap;
    }

    public static <T> IntObjectMap<T> newIntObjectMap(int theKey, T theValue) {
        IntObjectHashMap aMap = new IntObjectHashMap();
        aMap.put(theKey, theValue);
        return aMap;
    }

    public static LongIntProcedure addAllProcedure(LongIntHashMap toMap) {
        return (key, value) -> {
            int aValue = toMap.containsKey(key) ? toMap.indexGet(toMap.indexOf(key)) + value : value;
            toMap.put(key, aValue);
        };
    }

    public static <T> IntObjectMap<T> newIntObjectMap() {
        return new IntObjectHashMap();
    }

    public static <T> LongObjectMap<T> newLongObjectMap() {
        return new LongObjectHashMap();
    }

    public static <T> ObjectLongMap<T> newObjectLongMap() {
        return new ObjectLongHashMap();
    }

    public static void addAll(LongSet theSet, LongSet toAdd) {
        Iterator aIter = toAdd.iterator();
        while (aIter.hasNext()) {
            theSet.add(((LongCursor)aIter.next()).value);
        }
    }

    public static LongSet singleton(long theLong) {
        LongHashSet aSet = new LongHashSet();
        aSet.add(theLong);
        return aSet;
    }

    public static LongSet immutable(final LongSet theSet) {
        return new LongSet(){

            public boolean add(long l) {
                throw new UnsupportedOperationException();
            }

            public String visualizeKeyDistribution(int characters) {
                throw new UnsupportedOperationException();
            }

            public int removeAll(long e) {
                throw new UnsupportedOperationException();
            }

            public int removeAll(LongLookupContainer theLongCursors) {
                throw new UnsupportedOperationException();
            }

            public int removeAll(LongPredicate theLongPredicate) {
                throw new UnsupportedOperationException();
            }

            public int retainAll(LongLookupContainer theLongCursors) {
                throw new UnsupportedOperationException();
            }

            public int retainAll(LongPredicate theLongPredicate) {
                throw new UnsupportedOperationException();
            }

            public void clear() {
                throw new UnsupportedOperationException();
            }

            public void release() {
                throw new UnsupportedOperationException();
            }

            public Iterator<LongCursor> iterator() {
                return Iterators.unmodifiableIterator((Iterator)theSet.iterator());
            }

            public boolean contains(long l) {
                return theSet.contains(l);
            }

            public int size() {
                return theSet.size();
            }

            public boolean isEmpty() {
                return theSet.isEmpty();
            }

            public long[] toArray() {
                return theSet.toArray();
            }

            public <T extends LongProcedure> T forEach(T theT) {
                return (T)theSet.forEach(theT);
            }

            public <T extends LongPredicate> T forEach(T theT) {
                return (T)theSet.forEach(theT);
            }
        };
    }

    private static class CopyMapProcedure
    implements IntIntProcedure {
        private final IntIntHashMap mMap;

        public CopyMapProcedure(IntIntHashMap theMap) {
            this.mMap = theMap;
        }

        public void apply(int theKey, int theValue) {
            this.mMap.put(theKey, theValue);
        }
    }
}

