/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.graph;

import com.complexible.common.graph.DirectedGraph;
import com.complexible.common.graph.Edge;
import com.complexible.common.graph.Graph;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class GraphUtils {
    public static <V> boolean isConnected(Graph<V, ?> graph) {
        Set<V> aVertices = graph.getVertices();
        if (aVertices.isEmpty()) {
            return true;
        }
        HashSet aVisited = Sets.newHashSet();
        ArrayDeque aFrontier = Queues.newArrayDeque();
        aFrontier.add(aVertices.iterator().next());
        do {
            Object aNode = aFrontier.remove();
            aVisited.add(aNode);
            for (V aAdjacent : graph.getAdjacentVertices(aNode)) {
                if (aVisited.contains(aAdjacent)) continue;
                aFrontier.add(aAdjacent);
            }
        } while (!aFrontier.isEmpty());
        return aVisited.size() == aVertices.size();
    }

    public static <T> Set<Set<T>> getConnectedComponents(Graph<T, ?> graph) {
        HashSet components = Sets.newHashSet();
        HashSet visited = Sets.newHashSet();
        for (T node : graph.getVertices()) {
            if (!visited.add(node)) continue;
            components.add(GraphUtils.getConnectedComponent(visited, node, Sets.newHashSet(), graph::getIncidentEdges));
        }
        return components;
    }

    private static <V> Set<V> getConnectedComponent(Set<V> visited, V node, Set<V> component, Function<V, Iterable<? extends Edge<V, ?>>> getEdges) {
        component.add(node);
        Iterable<Edge<V, ?>> edges = getEdges.apply(node);
        for (Edge<V, ?> edge : edges) {
            V neighbor = edge.getOtherEnd(node);
            if (!visited.add(neighbor)) continue;
            GraphUtils.getConnectedComponent(visited, neighbor, component, getEdges);
        }
        return component;
    }

    public static <V, E> List<V> topologicalSort(DirectedGraph<V, E> inputGraph) {
        DirectedGraph g = inputGraph.copy();
        Set<V> possibleNoIncoming = g.getRoots();
        LinkedList<Object> sorted = new LinkedList<Object>();
        while (!possibleNoIncoming.isEmpty()) {
            Set<Object> noIncoming = possibleNoIncoming.stream().filter(n -> g.getIncomingEdges(n) == null || g.getIncomingEdges(n).isEmpty()).collect(Collectors.toSet());
            if (noIncoming.isEmpty()) {
                return null;
            }
            possibleNoIncoming.removeAll(noIncoming);
            sorted.addAll(noIncoming);
            noIncoming.stream().map(g::getAdjacentVertices).filter(Objects::nonNull).flatMap(Collection::stream).forEach(possibleNoIncoming::add);
            noIncoming.forEach(g::removeVertex);
        }
        if (sorted.size() < g.getVertices().size()) {
            return null;
        }
        return sorted;
    }

    public static <V, E> Set<Set<Edge<V, E>>> getCycles(Graph<V, E> theGraph, boolean theDistinctLabels, int maxLength) {
        return new CycleFinder<V, E>(theGraph, theDistinctLabels, maxLength).findAllCycles();
    }

    public static <V, E> Set<Edge<V, E>> getCycleEdges(Graph<V, E> theGraph, boolean theDistinctLabels, int maxLength) {
        return new CycleFinder<V, E>(theGraph, theDistinctLabels, maxLength).findAllCycleEdges();
    }

    public static <V, E> Set<Set<V>> stronglyConnectedComponents(DirectedGraph<V, E> graph) {
        Set vertices = graph.getVertices();
        if (vertices.isEmpty()) {
            return Collections.emptySet();
        }
        if (vertices.size() == 1) {
            return Set.of(vertices);
        }
        HashSet visited = new HashSet();
        ArrayDeque finishStack = new ArrayDeque();
        for (Object vertex : vertices) {
            if (visited.contains(vertex)) continue;
            GraphUtils.dfsForward(graph, vertex, visited, finishStack);
        }
        visited.clear();
        HashSet<Set<V>> components = new HashSet<Set<V>>();
        while (!finishStack.isEmpty()) {
            Object vertex;
            vertex = finishStack.pop();
            if (visited.contains(vertex)) continue;
            HashSet component = new HashSet();
            GraphUtils.dfsBackward(graph, vertex, visited, component);
            components.add(component);
        }
        return components;
    }

    private static <V, E> void dfsForward(DirectedGraph<V, E> graph, V vertex, Set<V> visited, Deque<V> finishStack) {
        visited.add(vertex);
        for (Edge<V, E> edge : graph.getOutgoingEdges(vertex)) {
            V neighbor = edge.getEnd();
            if (visited.contains(neighbor)) continue;
            GraphUtils.dfsForward(graph, neighbor, visited, finishStack);
        }
        finishStack.push(vertex);
    }

    private static <V, E> void dfsBackward(DirectedGraph<V, E> graph, V vertex, Set<V> visited, Set<V> component) {
        visited.add(vertex);
        component.add(vertex);
        for (Edge<V, E> edge : graph.getIncomingEdges(vertex)) {
            V neighbor = edge.getStart();
            if (visited.contains(neighbor)) continue;
            GraphUtils.dfsBackward(graph, neighbor, visited, component);
        }
    }

    public static <V, E> Set<V> getMinimalReachingSet(DirectedGraph<V, E> graph) {
        Set vertices = graph.getVertices();
        if (vertices.isEmpty()) {
            return Collections.emptySet();
        }
        if (vertices.size() == 1) {
            return Set.copyOf(vertices);
        }
        Set sccs = GraphUtils.stronglyConnectedComponents(graph);
        if (sccs.size() == 1) {
            return Set.of(sccs.iterator().next().iterator().next());
        }
        HashMap vertexToScc = new HashMap();
        for (Set set : sccs) {
            for (Object vertex : set) {
                vertexToScc.put(vertex, set);
            }
        }
        Set<Set> rootSccs = Collections.newSetFromMap(new IdentityHashMap());
        rootSccs.addAll(sccs);
        block2: for (Set set : sccs) {
            for (Object vertex : set) {
                for (Edge edge : graph.getIncomingEdges(vertex)) {
                    Object source = edge.getStart();
                    Set sourceScc = (Set)vertexToScc.get(source);
                    if (sourceScc == set) continue;
                    rootSccs.remove(set);
                    break;
                }
                if (rootSccs.contains(set)) continue;
                continue block2;
            }
        }
        HashSet hashSet = new HashSet();
        for (Set rootScc : rootSccs) {
            hashSet.add(rootScc.iterator().next());
        }
        return hashSet;
    }

    public static class CycleFinder<V, E> {
        private final int mMaxCycleLength;
        private final Graph<V, E> mGraph;
        private Set<Set<Edge<V, E>>> mCycles;
        private Set<Edge<V, E>> mCycleEdges;
        private final boolean mDistinctLabels;

        public CycleFinder(Graph<V, E> theGraph, boolean distinctLabels, int maxLength) {
            assert (maxLength > 1);
            this.mGraph = theGraph;
            this.mDistinctLabels = distinctLabels;
            this.mMaxCycleLength = maxLength;
        }

        public Set<Set<Edge<V, E>>> findAllCycles() {
            this.mCycles = new HashSet<Set<Edge<V, E>>>();
            this.mCycleEdges = null;
            this.search();
            return this.mCycles;
        }

        public Set<Edge<V, E>> findAllCycleEdges() {
            this.mCycles = null;
            this.mCycleEdges = Sets.newIdentityHashSet();
            this.search();
            return this.mCycleEdges;
        }

        private void search() {
            for (V node : this.mGraph.getVertices()) {
                for (Edge<V, E> edge : this.mGraph.getIncidentEdges(node)) {
                    this.findCycle(new Path<V, E>(edge));
                }
            }
        }

        private void addCycle(Path<V, E> cycle) {
            if (this.mCycleEdges == null) {
                this.mCycles.add(cycle.mEdges);
            } else if (this.mCycles == null) {
                this.mCycleEdges.addAll(cycle.mEdges);
            } else {
                throw new RuntimeException("Unexpected state in CycleFinder");
            }
        }

        private void findCycle(Path<V, E> path) {
            V end = path.getNext();
            for (Edge<V, E> nextEdge : this.mGraph.getIncidentEdges(end)) {
                V next;
                Path<V, E> newPath;
                if (path.contains(nextEdge) || this.mDistinctLabels && path.getLabels().contains(nextEdge.getLabel()) || (newPath = path.extend(nextEdge, next = end == nextEdge.getEnd() ? nextEdge.getStart() : nextEdge.getEnd())) == null) continue;
                if (newPath.isCycle()) {
                    this.addCycle(newPath);
                    continue;
                }
                if (newPath.length() >= this.mMaxCycleLength) continue;
                this.findCycle(newPath);
            }
        }

        static final class Path<V, E> {
            private final Set<Edge<V, E>> mEdges;
            private final V mStart;
            private final V mNext;
            private final Set<E> mLabels;
            private boolean mIsCycle = false;

            public Path(Edge<V, E> theEdge) {
                this.mEdges = Sets.newIdentityHashSet();
                this.mEdges.add(theEdge);
                this.mStart = theEdge.getStart();
                this.mNext = theEdge.getEnd();
                this.mLabels = Set.of(theEdge.getLabel());
            }

            public Path(Set<Edge<V, E>> edges, Set<E> labels, V start, V next, boolean isCycle) {
                this.mEdges = edges;
                this.mLabels = labels;
                this.mIsCycle = isCycle;
                this.mStart = start;
                this.mNext = next;
            }

            private Set<E> getLabels() {
                return this.mLabels;
            }

            public V getNext() {
                return this.mNext;
            }

            public boolean visited(V node) {
                for (Edge<V, E> edge : this.mEdges) {
                    if (node != edge.getEnd() && node != edge.getStart()) continue;
                    return true;
                }
                return false;
            }

            public boolean contains(Edge<V, E> theEdge) {
                return this.mEdges.contains(theEdge);
            }

            public boolean isCycle() {
                return this.mIsCycle;
            }

            public int length() {
                return this.mEdges.size();
            }

            public Path<V, E> extend(Edge<V, E> edge, V next) {
                boolean cycle;
                boolean bl = cycle = edge.getEnd() == this.mStart || edge.getStart() == this.mStart;
                if (!cycle && this.visited(next)) {
                    return null;
                }
                Set edges = Sets.newIdentityHashSet();
                edges.addAll(this.mEdges);
                edges.add(edge);
                HashSet<E> labels = new HashSet<E>(this.mLabels);
                labels.add(edge.getLabel());
                return new Path<V, E>(edges, labels, this.mStart, next, cycle);
            }
        }
    }
}

