/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.graph;

import com.complexible.common.graph.AbstractGraph;
import com.complexible.common.graph.Edge;
import com.complexible.common.graph.EdgeImpl;
import com.complexible.common.graph.Graph;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class GraphImpl<V, E>
extends AbstractGraph<V, E>
implements Graph<V, E> {
    public GraphImpl() {
        super(new HashMap());
    }

    @Override
    public boolean isDirected() {
        return false;
    }

    @Override
    public Edge<V, E> addEdge(E object, V start, V end) {
        EdgeImpl<V, E> edge = this.findEdge((Object)start, (Object)end, (Object)object);
        if (null == edge) {
            edge = new EdgeImpl<V, E>(object, start, end);
            this.addVertex(start);
            this.addVertex(end);
            this.getIncidentEdges((Object)start).add(edge);
            this.getIncidentEdges((Object)end).add(edge);
        }
        return edge;
    }

    @Override
    public Collection<Edge<V, E>> getIncidentEdges(V vertex) {
        return this.getVertexMap().get(vertex);
    }

    @Override
    public boolean addVertex(V vertex) {
        if (!this.getVertexMap().containsKey(vertex)) {
            this.getVertexMap().put(vertex, new HashSet());
            return true;
        }
        return false;
    }

    @Override
    public Set<V> getAdjacentVertices(V vertex) {
        Iterable incidentEdges = this.getIncidentEdges((Object)vertex);
        if (incidentEdges != null) {
            HashSet neighbors = new HashSet();
            for (Edge incident : incidentEdges) {
                neighbors.add(incident.getStart());
                neighbors.add(incident.getEnd());
            }
            neighbors.remove(vertex);
            return neighbors;
        }
        return Collections.emptySet();
    }

    @Override
    public boolean removeVertex(V vertex) {
        Iterable incidentEdges = this.getIncidentEdges((Object)vertex);
        if (incidentEdges != null) {
            for (Edge incident : incidentEdges) {
                Object otherEnd = vertex.equals(incident.getStart()) ? incident.getEnd() : incident.getStart();
                this.getIncidentEdges(otherEnd).remove(incident);
            }
            this.getVertexMap().remove(vertex);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeEdge(Edge<V, E> edge) {
        boolean removed = this.getIncidentEdges((Object)edge.getStart()).remove(edge);
        if (!this.isDirected()) {
            this.getIncidentEdges((Object)edge.getEnd()).remove(edge);
        }
        return removed;
    }

    @Override
    public EdgeImpl<V, E> findEdge(V start, V end, E label) {
        EdgeImpl edge = null;
        Iterable incidentEdges = this.getIncidentEdges((Object)start);
        if (incidentEdges == null) {
            return null;
        }
        for (Edge incident : incidentEdges) {
            if ((incident.getLabel() != null || label != null) && (label == null || !label.equals(incident.getLabel())) || !incident.getEnd().equals(end)) continue;
            edge = (EdgeImpl)incident;
            break;
        }
        return edge;
    }
}

