/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.graph;

import com.complexible.common.graph.Edge;

public class EdgeImpl<V, E>
implements Edge<V, E> {
    private final E mLabel;
    private final V mStart;
    private final V mEnd;

    public EdgeImpl(V start, V end) {
        this(null, start, end);
    }

    public EdgeImpl(E object, V start, V end) {
        this.mStart = start;
        this.mEnd = end;
        this.mLabel = object;
    }

    @Override
    public V getEnd() {
        return this.mEnd;
    }

    @Override
    public E getLabel() {
        return this.mLabel;
    }

    @Override
    public V getStart() {
        return this.mStart;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Edge) {
            Edge edge = (Edge)obj;
            return this.mStart.equals(edge.getStart()) && this.mEnd.equals(edge.getEnd()) && (this.mLabel == null && edge.getLabel() == null || this.mLabel != null && this.mLabel.equals(edge.getLabel()));
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mEnd.hashCode();
        result = 31 * result + (this.mLabel == null ? 0 : this.mLabel.hashCode());
        result = 31 * result + this.mStart.hashCode();
        return result;
    }

    public String toString() {
        return "<" + String.valueOf(this.mStart) + "," + String.valueOf(this.mEnd) + ": " + String.valueOf(this.mLabel) + ">";
    }

    @Override
    public V getOtherEnd(V oneEnd) {
        if (oneEnd == this.mStart) {
            return this.mEnd;
        }
        if (oneEnd == this.mEnd) {
            return this.mStart;
        }
        if (this.mStart.equals(oneEnd)) {
            return this.mEnd;
        }
        if (this.mEnd.equals(oneEnd)) {
            return this.mStart;
        }
        return null;
    }
}

