/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.graph;

import com.complexible.common.graph.AbstractGraph;
import com.complexible.common.graph.DirectedGraph;
import com.complexible.common.graph.Edge;
import com.complexible.common.graph.EdgeImpl;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DirectedGraphImpl<V, E>
extends AbstractGraph<V, E>
implements DirectedGraph<V, E> {
    protected final Map<V, Collection<Edge<V, E>>> mInvVertexMap;
    protected Set<V> mRoots = null;

    public DirectedGraphImpl() {
        this(new HashMap(), new HashMap());
        this.mRoots = new HashSet<V>();
    }

    public DirectedGraphImpl(Map<V, Collection<Edge<V, E>>> vertexMap, Map<V, Collection<Edge<V, E>>> invVertexMap) {
        super(vertexMap);
        this.mInvVertexMap = invVertexMap;
    }

    @Override
    public DirectedGraphImpl<V, E> copy() {
        return new DirectedGraphImpl(DirectedGraphImpl.copyVertexMap(this.getVertexMap()), DirectedGraphImpl.copyVertexMap(this.mInvVertexMap));
    }

    private static <V, E> Map<V, Collection<Edge<V, E>>> copyVertexMap(Map<V, Collection<Edge<V, E>>> map) {
        HashMap newMap = new HashMap(map.size());
        map.forEach((k, v) -> newMap.put(k, Sets.newHashSet((Iterable)v)));
        return newMap;
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    @Override
    public Edge<V, E> addEdge(E object, V start, V end) {
        Edge<V, E> edge;
        if (!this.getVertexMap().containsKey(start) || null == (edge = this.findEdge(start, end, object))) {
            edge = new EdgeImpl<V, E>(object, start, end);
            this.addVertex(start);
            this.addVertex(end);
            this.getOutgoingEdges(start).add(edge);
            this.getIncomingEdges(end).add(edge);
            if (this.mRoots != null) {
                this.mRoots.remove(end);
            }
        }
        return edge;
    }

    @Override
    public Iterable<Edge<V, E>> getIncidentEdges(V vertex) {
        return Iterables.concat(this.getOutgoingEdges(vertex), this.getIncomingEdges(vertex));
    }

    @Override
    public Collection<Edge<V, E>> getIncomingEdges(V vertex) {
        return this.mInvVertexMap.get(vertex);
    }

    @Override
    public boolean addVertex(V vertex) {
        if (!this.getVertexMap().containsKey(vertex)) {
            this.getVertexMap().put(vertex, new HashSet());
            this.mInvVertexMap.put(vertex, new HashSet());
            if (this.mRoots != null) {
                this.mRoots.add(vertex);
            }
            return true;
        }
        return false;
    }

    @Override
    public Set<V> getAdjacentVertices(V start) {
        Collection<Edge<V, E>> incidentEdges = this.getOutgoingEdges(start);
        if (incidentEdges != null) {
            HashSet<V> neighbors = new HashSet<V>();
            for (Edge<V, E> incident : incidentEdges) {
                neighbors.add(incident.getEnd());
            }
            return neighbors;
        }
        return null;
    }

    @Override
    public Set<V> getAdjacentIncomingVertices(V end) {
        Collection<Edge<V, E>> incidentEdges = this.getIncomingEdges(end);
        if (incidentEdges != null) {
            HashSet<V> neighbors = new HashSet<V>();
            for (Edge<V, E> incident : incidentEdges) {
                neighbors.add(incident.getStart());
            }
            return neighbors;
        }
        return null;
    }

    @Override
    public boolean removeVertex(V vertex) {
        if (!this.getVertexMap().containsKey(vertex)) {
            return false;
        }
        for (Edge<V, E> incoming : this.getIncomingEdges(vertex)) {
            this.getOutgoingEdges(incoming.getStart()).remove(incoming);
        }
        for (Edge<V, E> outbound : this.getOutgoingEdges(vertex)) {
            this.getIncomingEdges(outbound.getEnd()).remove(outbound);
        }
        this.mInvVertexMap.remove(vertex);
        this.getVertexMap().remove(vertex);
        this.mRoots = null;
        return true;
    }

    @Override
    public boolean removeEdge(Edge<V, E> edge) {
        boolean removed = this.getOutgoingEdges(edge.getStart()).remove(edge);
        if (removed |= this.getIncomingEdges(edge.getEnd()).remove(edge)) {
            this.mRoots = null;
        }
        return removed;
    }

    public Edge<V, E> findEdge(V start, V end) {
        for (Edge<V, E> incident : this.getIncidentEdges(start)) {
            if (!incident.getEnd().equals(end) || !incident.getStart().equals(start)) continue;
            return incident;
        }
        return null;
    }

    @Override
    public Set<V> getRoots() {
        return this.mRoots != null ? this.mRoots : this.discoverRoots();
    }

    private Set<V> discoverRoots() {
        this.mRoots = new HashSet(this.getVertexMap().keySet());
        for (Object vertex : this.getVertexMap().keySet()) {
            if (this.getIncomingEdges(vertex).isEmpty()) continue;
            this.mRoots.remove(vertex);
        }
        return this.mRoots;
    }

    @Override
    public Collection<Edge<V, E>> getOutgoingEdges(V vertex) {
        return this.getVertexMap().get(vertex);
    }

    @Override
    public Edge<V, E> findEdge(V start, V end, E label) {
        for (Edge<V, E> incident : this.getIncidentEdges(start)) {
            if (!incident.getEnd().equals(end) || !incident.getStart().equals(start) || (label != null || incident.getLabel() != null) && (label == null || !label.equals(incident.getLabel()))) continue;
            return incident;
        }
        return null;
    }
}

