/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.dataexporter;

import com.brsanthu.dataexporter.model.AlignType;
import com.brsanthu.dataexporter.model.Column;
import com.complexible.common.dataexporter.FormattedColumn;
import com.complexible.common.dataexporter.MergedColumn;
import com.complexible.common.dataexporter.WordWrapStringColumn;
import com.google.common.collect.ImmutableList;

public class Columns {
    public static FormattedColumn string(String name) {
        return new WordWrapStringColumn(name);
    }

    public static FormattedColumn string(String name, AlignType align) {
        return new WordWrapStringColumn(name, align);
    }

    public static FormattedColumn integer(String name) {
        return new FormattedColumn(name, "%,d", AlignType.TOP_RIGHT);
    }

    public static FormattedColumn decimal(String name) {
        return Columns.decimal(name, 1);
    }

    public static FormattedColumn decimal(String name, int fractionDigits) {
        return new FormattedColumn(name, "%,1." + fractionDigits + "f", AlignType.TOP_RIGHT);
    }

    public static FormattedColumn format(String name, String format) {
        return new FormattedColumn(name, format, AlignType.TOP_RIGHT);
    }

    public static MergedColumn merge(String title, Column ... columns) {
        return new MergedColumn(title, (Iterable<Column>)ImmutableList.copyOf((Object[])columns));
    }

    public static void ensureWidth(Column column, int width) {
        column.setWidth(Math.max(column.getWidth(), width));
    }
}

