/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.complexible.common.primitives.ArrayUtil;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class UpdatablePriorityQueue<T>
extends AbstractCollection<T>
implements Queue<T> {
    private static final int DEFAULT_CAPACITY = 100;
    private int currentSize;
    private T[] data;
    private Comparator<? super T> cmp;

    public UpdatablePriorityQueue(Comparator<? super T> c) {
        this(101, c);
    }

    public UpdatablePriorityQueue(Collection<? extends T> coll, Comparator<? super T> c) {
        this(coll.size(), c);
        this.currentSize = coll.size();
        int i = 1;
        for (T item : coll) {
            this.data[i++] = item;
        }
        this.buildHeap();
    }

    public UpdatablePriorityQueue(int initialSize, Comparator<? super T> c) {
        this.cmp = c;
        this.currentSize = 0;
        this.data = ArrayUtil.newArray((initialSize + 2) * 11 / 10);
    }

    @Override
    public boolean offer(T x) {
        return this.add(x);
    }

    @Override
    public boolean add(T x) {
        if (this.currentSize + 1 == this.data.length) {
            this.increseCapacity();
        }
        this.data[0] = x;
        int hole = ++this.currentSize;
        while (this.cmp.compare(x, this.data[hole / 2]) < 0) {
            this.data[hole] = this.data[hole / 2];
            hole /= 2;
        }
        this.data[hole] = x;
        return true;
    }

    @Override
    public int size() {
        return this.currentSize;
    }

    @Override
    public void clear() {
        this.currentSize = 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int current = 0;

            @Override
            public boolean hasNext() {
                return this.current != UpdatablePriorityQueue.this.size();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return UpdatablePriorityQueue.this.data[++this.current];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public T element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.data[1];
    }

    @Override
    public T peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.data[1];
    }

    @Override
    public T poll() {
        if (this.isEmpty()) {
            return null;
        }
        T minItem = this.data[1];
        this.data[1] = this.data[this.currentSize--];
        this.moveDown(1);
        return minItem;
    }

    @Override
    public T remove() {
        T result = this.poll();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    public void update() {
        if (this.isEmpty()) {
            return;
        }
        this.moveDown(1);
    }

    public T replace(T newElement) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        T result = this.data[1];
        this.data[1] = newElement;
        this.moveDown(1);
        return result;
    }

    private void buildHeap() {
        for (int i = this.currentSize / 2; i > 0; --i) {
            this.moveDown(i);
        }
    }

    private void moveDown(int hole) {
        T tmp = this.data[hole];
        while (hole * 2 <= this.currentSize) {
            int child = hole * 2;
            if (child != this.currentSize && this.cmp.compare(this.data[child + 1], this.data[child]) < 0) {
                ++child;
            }
            if (this.cmp.compare(this.data[child], tmp) >= 0) break;
            this.data[hole] = this.data[child];
            hole = child;
        }
        this.data[hole] = tmp;
    }

    private void increseCapacity() {
        this.data = Arrays.copyOf(this.data, this.data.length * 2);
    }
}

