/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.complexible.common.collect.SkippingIterator;
import com.complexible.common.collect.SkippingLongIterator;
import java.util.NoSuchElementException;

public abstract class TransformingLongIterator<T>
implements SkippingLongIterator {
    private final SkippingIterator<T> mBaseIt;
    private final boolean mSkipValues;
    private long mPrev = Long.MIN_VALUE;
    private long mNext = Long.MIN_VALUE;

    public TransformingLongIterator(SkippingIterator<T> theBaseIt, boolean theSkipValues) {
        this.mBaseIt = theBaseIt;
        this.mSkipValues = theSkipValues;
    }

    protected abstract long getLong(T var1);

    protected abstract T getSkipTarget(long var1);

    private void fetchNext() {
        if (this.mNext != Long.MIN_VALUE) {
            return;
        }
        T aCount = null;
        if (this.mSkipValues && this.mPrev != Long.MIN_VALUE) {
            if (this.mBaseIt.skipTo(this.getSkipTarget(this.mPrev + 1L))) {
                aCount = (T)this.mBaseIt.next();
            }
        } else if (this.mBaseIt.hasNext()) {
            aCount = (T)this.mBaseIt.next();
        }
        this.mNext = aCount == null ? Long.MIN_VALUE : this.getLong(aCount);
    }

    @Override
    public boolean hasNext() {
        this.fetchNext();
        return this.mNext != Long.MIN_VALUE;
    }

    @Override
    public long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.mPrev = this.mNext;
        this.mNext = Long.MIN_VALUE;
        return this.mPrev;
    }

    @Override
    public long peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.mNext;
    }

    @Override
    public boolean skipTo(long theValue) {
        if (!this.mSkipValues) {
            throw new UnsupportedOperationException("Skipping not supported");
        }
        if (theValue == this.mNext) {
            return true;
        }
        this.mNext = Long.MIN_VALUE;
        if (!this.mBaseIt.skipTo(this.getSkipTarget(theValue))) {
            this.mPrev = Long.MIN_VALUE;
            return false;
        }
        Object aCount = this.mBaseIt.next();
        this.mNext = this.getLong(aCount);
        return true;
    }

    @Override
    public void reset() {
        this.mBaseIt.reset();
        this.mNext = Long.MIN_VALUE;
        this.fetchNext();
    }

    @Override
    public void close() {
        this.mBaseIt.close();
    }
}

