/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.complexible.common.base.Copyable;
import com.complexible.common.collect.BufferList;
import com.complexible.common.collect.BufferLists;
import com.complexible.common.collect.MarkResetSkippingIterator;
import com.complexible.common.collect.PeekingSkippingIterator;
import com.complexible.common.collect.RestrictedMarkResetIterator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.PeekingIterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class SpoolingMarkResetIterator<T extends Copyable<T>>
implements RestrictedMarkResetIterator<T> {
    private PeekingIterator<T> mActive;
    private final MarkResetSkippingIterator<T> mResettable;
    private final BufferList<T> mSpooled;
    private State mState = State.SOURCE_SPOOL;
    private T mMark = null;
    private Predicate<T> mRestriction = t -> true;
    private T mNext = null;

    public SpoolingMarkResetIterator(PeekingSkippingIterator<T> theIterator, int theSpoolLimit) {
        this.mResettable = new MarkResetSkippingIterator<T>(theIterator);
        this.mSpooled = BufferLists.limited(Math.min(64, theSpoolLimit), theSpoolLimit);
        this.mActive = this.mResettable;
    }

    private SpoolingMarkResetIterator(SpoolingMarkResetIterator<T> theIterator) {
        this.mResettable = theIterator.mResettable.copy();
        this.mSpooled = theIterator.mSpooled;
        this.mSpooled.clear();
        this.mActive = this.mResettable;
        this.mState = State.SOURCE_SPOOL;
        this.mMark = null;
        this.mRestriction = theIterator.mRestriction;
    }

    @Override
    public void restrict(Predicate<T> restriction) {
        this.mRestriction = restriction;
        this.mResettable.restrict(restriction);
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T tmp = this.mNext;
        this.mNext = null;
        return tmp;
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (this.mNext != null) {
                return true;
            }
            if (this.mActive.hasNext()) {
                switch (this.mState.ordinal()) {
                    case 0: {
                        Copyable result = (Copyable)this.mActive.peek();
                        if (this.mRestriction.test(result)) {
                            this.mActive.next();
                            this.mNext = result;
                            return true;
                        }
                        return false;
                    }
                    case 1: {
                        Copyable result = (Copyable)this.mActive.peek();
                        if (this.mRestriction.test(result)) {
                            this.mActive.next();
                            if (this.mMark != null && !this.spool(result)) {
                                this.mSpooled.clear();
                                this.mState = State.SOURCE;
                            }
                            this.mNext = result;
                            return true;
                        }
                        return false;
                    }
                    case 2: {
                        this.mNext = (Copyable)this.mActive.next();
                        return true;
                    }
                }
                continue;
            }
            if (this.mState != State.SPOOLED) break;
            this.mActive = this.mResettable;
            this.mState = State.SOURCE_SPOOL;
        }
        return false;
    }

    private boolean spool(T element) {
        if (this.mSpooled.isFull()) {
            return false;
        }
        this.mSpooled.add(element.copy());
        return true;
    }

    @Override
    public void mark(T mark) {
        Preconditions.checkState((this.mState != State.SPOOLED ? 1 : 0) != 0, (Object)"This iterator cannot set a new mark while iterating over spooled data");
        this.mSpooled.clear();
        this.mState = State.SOURCE_SPOOL;
        this.mResettable.mark(mark);
        this.mMark = mark;
    }

    @Override
    public void resetToMark() {
        if (this.mMark == null) {
            throw new NoSuchElementException();
        }
        switch (this.mState.ordinal()) {
            case 0: {
                this.mResettable.resetToMark();
                this.mActive = this.mResettable;
                this.mState = State.SOURCE;
                break;
            }
            case 1: 
            case 2: {
                this.mActive = this.mSpooled.iterator();
                this.mState = State.SPOOLED;
                this.mNext = this.mMark;
            }
        }
    }

    @Override
    public void close() {
        this.mResettable.close();
    }

    @Override
    public void reset() {
        this.mResettable.reset();
        this.mMark = null;
        this.mSpooled.clear();
        this.mState = State.SOURCE_SPOOL;
        this.mActive = this.mResettable;
    }

    @Override
    public RestrictedMarkResetIterator<T> copy() {
        return new SpoolingMarkResetIterator<T>(this);
    }

    @VisibleForTesting
    int getSpooledSize() {
        return this.mSpooled.size();
    }

    private static enum State {
        SOURCE,
        SOURCE_SPOOL,
        SPOOLED;

    }
}

