/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.carrotsearch.hppc.ObjectArrayList;
import com.complexible.common.collect.QueuedSortedIterator;
import com.complexible.common.collect.UpdatablePriorityQueue;
import com.complexible.common.primitives.ArrayUtil;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class SortedIterators {
    private static final BiFunction<Object, Object, Object> PICK_FIRST = (theArg1, theArg2) -> theArg1;
    private static final Function<Iterator, PeekingIterator> PEEKING_TRANSFORM = theIterator -> theIterator instanceof PeekingIterator ? (PeekingIterator)theIterator : Iterators.peekingIterator((Iterator)theIterator);
    private static final ObjectArrayList FINAL = new ObjectArrayList(0);
    private static final int LIST_SIZE = 100000;

    private SortedIterators() {
        throw new AssertionError();
    }

    private static <T> Function<Iterator<T>, PeekingIterator<T>> peekingTransform() {
        return PEEKING_TRANSFORM;
    }

    private static <T> PeekingIterator<T> peekingIterator(Iterator<T> theIterator) {
        return theIterator instanceof PeekingIterator ? (PeekingIterator)theIterator : Iterators.peekingIterator(theIterator);
    }

    public static <T> QueuedSortedIterator<T> queued(Iterator<T> theIterator, Comparator<T> theComparator) {
        return new QueuedSortedIterator<T>(SortedIterators.peekingTransform().apply(theIterator), theComparator);
    }

    public static <T> Iterator<T> union(Iterator<T> theIterator1, Iterator<T> theIterator2, Comparator<T> theComparator) {
        return new UnionPairIterator<Object>(theIterator1, theIterator2, theComparator, PICK_FIRST);
    }

    public static <T> Iterator<T> union(Iterator<T> theIterator1, Iterator<T> theIterator2, Comparator<T> theComparator, BiFunction<T, T, T> theMergeFunc) {
        return new UnionPairIterator<T>(theIterator1, theIterator2, theComparator, theMergeFunc);
    }

    public static <T> PeekingIterator<T> union(Iterable<? extends Iterator<T>> theIterators, Comparator<T> theComparator) {
        ArrayList aIterators = Lists.newArrayList();
        for (Iterator<T> aIterator : theIterators) {
            if (!aIterator.hasNext()) continue;
            aIterators.add(SortedIterators.peekingIterator(aIterator));
        }
        return new UnionMultiIterator<T>(SortedIterators.createQueue(aIterators, theComparator));
    }

    public static <T> UnionBuilder<T> unionBuilder(Comparator<T> theComparator, int theExpectedSize) {
        return new UnionBuilder<T>(theExpectedSize, theComparator);
    }

    private static <T> UpdatablePriorityQueue<PeekingIterator<T>> createQueue(Collection<PeekingIterator<T>> theElements, Comparator<T> theComparator) {
        return new UpdatablePriorityQueue<PeekingIterator<T>>(theElements, (o1, o2) -> theComparator.compare(o1.peek(), o2.peek()));
    }

    public static <T> Iterator<T> unionMultiThreaded(List<? extends Iterator<T>> theIterators, Comparator<T> theComparator, ExecutorService theExecutor) {
        int n = theIterators.size();
        if (n <= 3) {
            return SortedIterators.union(theIterators, theComparator);
        }
        int split = n / 2;
        List<? extends Iterator<T>> theIterators1 = theIterators.subList(0, split);
        List<? extends Iterator<T>> theIterators2 = theIterators.subList(split, n);
        BulkIteratorFiller<T> aFiller1 = new BulkIteratorFiller<T>(SortedIterators.union(theIterators1, theComparator));
        BulkIteratorFiller<T> aFiller2 = new BulkIteratorFiller<T>(SortedIterators.union(theIterators2, theComparator));
        theExecutor.submit(aFiller1);
        theExecutor.submit(aFiller2);
        return SortedIterators.union(aFiller1.bulkIterator(), aFiller2.bulkIterator(), theComparator);
    }

    public static <T> PeekingIterator<T> uniqueIterator(PeekingIterator<T> theIterator, Comparator<T> theComparator, BiFunction<T, T, T> theFunction) {
        return new CollapsingIterator<T>(theIterator, theComparator, theFunction);
    }

    public static <T> PeekingIterator<T> uniqueIterator(PeekingIterator<T> theIterator, Comparator<? super T> theComparator) {
        return new CollapsingIterator<Object>(theIterator, theComparator, PICK_FIRST);
    }

    private static class UnionPairIterator<T>
    extends UnmodifiableIterator<T>
    implements Iterator<T> {
        private final Iterator<T> mFirstIterator;
        private final Iterator<T> mSecondIterator;
        private final Comparator<T> mComparator;
        private final BiFunction<T, T, T> mMergeFunc;
        private T mFirstHead;
        private T mSecondHead;
        private boolean mFirstFetched;
        private boolean mSecondFetched;

        UnionPairIterator(Iterator<T> theFirstIterator, Iterator<T> theSecondIterator, Comparator<T> theComparator, BiFunction<T, T, T> theMergeFunc) {
            this.mFirstIterator = theFirstIterator;
            this.mSecondIterator = theSecondIterator;
            this.mComparator = theComparator;
            this.mMergeFunc = theMergeFunc;
            this.mFirstFetched = false;
            this.mSecondFetched = false;
        }

        private void fetchNext() {
            if (!this.mFirstFetched) {
                this.mFirstFetched = true;
                this.mFirstHead = this.mFirstIterator.hasNext() ? this.mFirstIterator.next() : null;
                Object v0 = this.mFirstHead;
            }
            if (!this.mSecondFetched) {
                this.mSecondFetched = true;
                this.mSecondHead = this.mSecondIterator.hasNext() ? this.mSecondIterator.next() : null;
            }
        }

        @Override
        public boolean hasNext() {
            this.fetchNext();
            return this.mFirstHead != null || this.mSecondHead != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.pickSmall();
        }

        private T pickSmall() {
            if (this.mFirstHead == null) {
                if (this.mSecondHead == null) {
                    return null;
                }
                this.mSecondFetched = false;
                return this.mSecondHead;
            }
            if (this.mSecondHead == null) {
                this.mFirstFetched = false;
                return this.mFirstHead;
            }
            int aCmp = this.mComparator.compare(this.mFirstHead, this.mSecondHead);
            if (aCmp == 0) {
                this.mSecondFetched = false;
                this.mFirstFetched = false;
                return this.mMergeFunc.apply(this.mFirstHead, this.mSecondHead);
            }
            if (aCmp <= 0) {
                this.mFirstFetched = false;
                this.mSecondFetched = aCmp != 0;
                return this.mFirstHead;
            }
            this.mSecondFetched = false;
            return this.mSecondHead;
        }
    }

    private static class UnionMultiIterator<T>
    extends UnmodifiableIterator<T>
    implements PeekingIterator<T> {
        private final UpdatablePriorityQueue<PeekingIterator<T>> theHeap;
        private T next;
        private T previous;

        private UnionMultiIterator(UpdatablePriorityQueue<PeekingIterator<T>> theHeap) {
            this.theHeap = theHeap;
            this.next = this.getNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public T next() {
            this.previous = this.next;
            this.next = this.getNext();
            return this.previous;
        }

        public T peek() {
            return this.next;
        }

        private T getNext() {
            while (!this.theHeap.isEmpty()) {
                PeekingIterator<T> current = this.theHeap.peek();
                Object element = current.next();
                if (current.hasNext()) {
                    this.theHeap.update();
                } else {
                    this.theHeap.remove();
                }
                if (element.equals(this.previous)) continue;
                return (T)element;
            }
            return null;
        }
    }

    public static class UnionBuilder<T> {
        private final UpdatablePriorityQueue<PeekingIterator<T>> mQueue;

        public UnionBuilder(int theExpectedSize, Comparator<T> theComparator) {
            this.mQueue = new UpdatablePriorityQueue(theExpectedSize, (o1, o2) -> theComparator.compare(o1.peek(), o2.peek()));
        }

        public UnionBuilder<T> add(PeekingIterator<T> theIterator) {
            this.mQueue.add(theIterator);
            return this;
        }

        public PeekingIterator<T> build() {
            return new UnionMultiIterator<T>(this.mQueue);
        }
    }

    private static class BulkIteratorFiller<T>
    implements Callable<Void> {
        private BlockingQueue<ObjectArrayList<T>> mWorkQueue = new ArrayBlockingQueue<ObjectArrayList<T>>(2);
        private BlockingQueue<ObjectArrayList<T>> mFreeQueue = new ArrayBlockingQueue<ObjectArrayList<T>>(2);
        private final Iterator<T> mBaseIterator;
        private final BulkIterator<T> mBulkIterator;

        private BulkIteratorFiller(Iterator<T> theIterator) {
            this.mBaseIterator = theIterator;
            this.mWorkQueue = new ArrayBlockingQueue<ObjectArrayList<T>>(2);
            this.mFreeQueue = new ArrayBlockingQueue<ObjectArrayList<T>>(2);
            this.mFreeQueue.add(new ObjectArrayList(100000));
            this.mBulkIterator = new BulkIterator<T>(this.mWorkQueue, this.mFreeQueue);
        }

        private BulkIterator<T> bulkIterator() {
            return this.mBulkIterator;
        }

        @Override
        public Void call() throws Exception {
            while (this.mBaseIterator.hasNext()) {
                ObjectArrayList<T> aBuffer = this.mFreeQueue.take();
                aBuffer.elementsCount = 0;
                for (int i = 0; i < 100000 && this.mBaseIterator.hasNext(); ++i) {
                    aBuffer.add(this.mBaseIterator.next());
                }
                Uninterruptibles.putUninterruptibly(this.mWorkQueue, aBuffer);
            }
            Uninterruptibles.putUninterruptibly(this.mWorkQueue, (Object)FINAL);
            return null;
        }
    }

    private static class BulkIterator<T>
    extends UnmodifiableIterator<T>
    implements PeekingIterator<T> {
        private BlockingQueue<ObjectArrayList<T>> mWorkQueue;
        private BlockingQueue<ObjectArrayList<T>> mFreeQueue;
        private ObjectArrayList<T> mList;
        private PeekingIterator<T> mCurrent;

        private BulkIterator(BlockingQueue<ObjectArrayList<T>> theWorkQueue, BlockingQueue<ObjectArrayList<T>> theFreeQueue) {
            this.mWorkQueue = theWorkQueue;
            this.mFreeQueue = theFreeQueue;
            this.mList = null;
            this.mCurrent = Iterators.peekingIterator((Iterator)ImmutableSet.of().iterator());
        }

        private PeekingIterator<T> current() {
            if (!this.mCurrent.hasNext() && this.mList != FINAL) {
                if (this.mList != null) {
                    Uninterruptibles.putUninterruptibly(this.mFreeQueue, this.mList);
                }
                this.mList = (ObjectArrayList)Uninterruptibles.takeUninterruptibly(this.mWorkQueue);
                this.mCurrent = ArrayUtil.iterator(this.mList.buffer, 0, this.mList.elementsCount);
                if (this.mList == FINAL) {
                    Uninterruptibles.putUninterruptibly(this.mWorkQueue, this.mList);
                }
            }
            return this.mCurrent;
        }

        public boolean hasNext() {
            return this.current().hasNext();
        }

        public T peek() {
            return (T)this.current().peek();
        }

        public T next() {
            return (T)this.current().next();
        }
    }

    private static class CollapsingIterator<T>
    extends UnmodifiableIterator<T>
    implements PeekingIterator<T> {
        private final PeekingIterator<T> mIterator;
        private final Comparator<? super T> mComparator;
        private final BiFunction<T, T, T> mFunction;
        private T mNext;

        private CollapsingIterator(PeekingIterator<T> theIterator, Comparator<? super T> theComparator, BiFunction<T, T, T> theFunction) {
            this.mIterator = theIterator;
            this.mComparator = theComparator;
            this.mFunction = theFunction;
            this.mNext = this.findNext();
        }

        private T findNext() {
            if (!this.mIterator.hasNext()) {
                return null;
            }
            Object aVal = this.mIterator.next();
            while (this.mIterator.hasNext() && this.mComparator.compare(aVal, this.mIterator.peek()) == 0) {
                aVal = this.mFunction.apply(aVal, this.mIterator.next());
            }
            return (T)aVal;
        }

        public boolean hasNext() {
            return this.mNext != null;
        }

        public T next() {
            T mResult = this.mNext;
            this.mNext = this.findNext();
            return mResult;
        }

        public T peek() {
            return this.mNext;
        }
    }
}

