/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Copyable;
import com.complexible.common.base.Disposables;
import com.complexible.common.collect.AbstractSkippingIterator;
import com.complexible.common.collect.NaryUnionSkippingIterator;
import com.complexible.common.collect.PeekingSkippingIterator;
import com.complexible.common.collect.ResettableIterator;
import com.complexible.common.collect.ResettableIterators;
import com.complexible.common.collect.ResettablePredicate;
import com.complexible.common.collect.SkippingIterator;
import com.complexible.common.primitives.ArrayUtil;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.MustBeClosed;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

public final class SkippingIterators {
    private static final SkippingIterator<Object> EMPTY = new PeekingSkippingIterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
        }

        public Object peek() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean skipTo(Object theTarget) {
            return false;
        }

        @Override
        public Comparator<Object> comparator() {
            return SkippingIterators.allEqual();
        }

        @Override
        public long estimatedSize() {
            return 0L;
        }

        @Override
        public void reset() {
        }

        @Override
        public void close() {
        }
    };
    private static final BiFunction<Object, Object, Object> PICK_FIRST = (theArg1, theArg2) -> theArg1;

    private SkippingIterators() {
        throw new AssertionError();
    }

    public static <T> SkippingIterator<T> forIterator(final ResettableIterator<T> theSource, final Comparator<T> theComparator) {
        return new AbstractSkippingIterator<T>(theComparator){

            @Override
            protected T computeNext() {
                return theSource.hasNext() ? theSource.next() : this.endOfData();
            }

            @Override
            protected T computeSkipTo(T theTarget) {
                while (theSource.hasNext()) {
                    Object aNext = theSource.next();
                    if (theComparator.compare(theTarget, aNext) > 0) continue;
                    return aNext;
                }
                return this.endOfData();
            }

            @Override
            protected void performReset() {
                theSource.reset();
            }

            @Override
            public void close() {
                super.close();
                Disposables.markReleased(this);
                theSource.close();
            }
        };
    }

    public static <T> PeekingSkippingIterator<T> forArray(T[] theArray, Comparator<T> theComparator) {
        return new ArraySkippingIterator<T>(theArray, theComparator);
    }

    public static <T> SkippingIterator<T> forArray(T[] theArray, int theStart, int theEnd, Comparator<T> theComparator) {
        return new ArraySkippingIterator<T>(theArray, theStart, theEnd, theComparator);
    }

    @MustBeClosed
    public static <T> ResettablePredicate<T> sortedContains(final SkippingIterator<T> theIterator) {
        final Comparator<T> theComparator = theIterator.comparator();
        return new ResettablePredicate<T>(){
            T theLastElement = null;

            @Override
            public boolean test(T theElement) {
                int aCmp;
                int n = aCmp = this.theLastElement == null ? 1 : theComparator.compare(theElement, this.theLastElement);
                if (aCmp < 0) {
                    return false;
                }
                if (aCmp == 0) {
                    return true;
                }
                if (!theIterator.skipTo(theElement)) {
                    return false;
                }
                this.theLastElement = theIterator.next();
                return theComparator.compare(theElement, this.theLastElement) == 0;
            }

            @Override
            public void reset() {
                theIterator.reset();
                this.theLastElement = null;
            }

            @Override
            public void close() {
                theIterator.close();
            }
        };
    }

    @MustBeClosed
    public static <T> ResettablePredicate<T> sortedContains(final SkippingIterator<T> theIterator, final BiPredicate<T, T> theEquality) {
        final Comparator<T> theComparator = theIterator.comparator();
        return new ResettablePredicate<T>(){
            T theLastElement = null;

            @Override
            public boolean test(T theElement) {
                if (this.theLastElement != null) {
                    if (theEquality.test(theElement, this.theLastElement)) {
                        return true;
                    }
                    if (theComparator.compare(theElement, this.theLastElement) < 0) {
                        return false;
                    }
                }
                if (!theIterator.skipTo(theElement)) {
                    return false;
                }
                this.theLastElement = theIterator.next();
                return theEquality.test(theElement, this.theLastElement);
            }

            @Override
            public void reset() {
                theIterator.reset();
                this.theLastElement = null;
            }

            @Override
            public void close() {
                theIterator.close();
            }
        };
    }

    @MustBeClosed
    public static <T> ResettablePredicate<T> sortedNotContains(final SkippingIterator<T> theIterator) {
        final Comparator<T> theComparator = theIterator.comparator();
        return new ResettablePredicate<T>(){
            private T mNext;
            {
                this.mNext = theIterator.hasNext() ? theIterator.next() : null;
            }

            @Override
            public boolean test(T theElement) {
                if (this.mNext == null) {
                    return true;
                }
                int aCmp = theComparator.compare(theElement, this.mNext);
                if (aCmp > 0) {
                    this.mNext = theIterator.skipTo(theElement) ? theIterator.next() : null;
                    Object v0 = this.mNext;
                    if (this.mNext != null && this.mNext.equals(theElement)) {
                        aCmp = 0;
                    }
                }
                return aCmp != 0;
            }

            @Override
            public void reset() {
                theIterator.reset();
                this.mNext = theIterator.hasNext() ? theIterator.next() : null;
            }

            @Override
            public void close() {
                theIterator.close();
            }
        };
    }

    @MustBeClosed
    public static <T> PeekingSkippingIterator<T> iterateRange(SkippingIterator<T> theIterator, T theMin, T theMax) {
        return new RangeIterator<T>(theIterator, theMin, theMax);
    }

    @MustBeClosed
    public static <T> PeekingSkippingIterator<T> iterateBeginning(SkippingIterator<T> theIterator, T theMin) {
        return new RangeIterator<Object>((SkippingIterator<Object>)theIterator, theMin, null);
    }

    @MustBeClosed
    public static <T> PeekingSkippingIterator<T> iterateUntil(SkippingIterator<T> theIterator, T theMax) {
        return new RangeIterator<Object>((SkippingIterator<Object>)theIterator, null, theMax);
    }

    @MustBeClosed
    public static <T> PeekingSkippingIterator<T> filter(SkippingIterator<T> theIterator, Predicate<? super T> theFilter) {
        return new FilteringSkippingIterator<T>(theIterator, theFilter);
    }

    @MustBeClosed
    public static <T> PeekingSkippingIterator<T> distinct(SkippingIterator<T> theIterator) {
        return new DistinctSkippingIterator<T>(theIterator);
    }

    @MustBeClosed
    public static <T> SkippingIterator<T> minus(SkippingIterator<T> theIterator, SkippingIterator<T> theFilteredElements) {
        if (!theFilteredElements.hasNext()) {
            return theIterator;
        }
        PeekingSkippingIterator<T> filteredIterator = SkippingIterators.filter(theIterator, SkippingIterators.sortedNotContains(theFilteredElements));
        return filteredIterator;
    }

    @MustBeClosed
    public static <I, O> SkippingIterator<O> transform(SkippingIterator<I> theIterator, Function<I, O> theFunction, Function<O, I> theInverseFunction, Comparator<O> theComparator) {
        return new TransformingSkippingIterator<I, O>(theIterator, theComparator, theFunction, theInverseFunction);
    }

    @MustBeClosed
    public static <T> SkippingIterator<T> wrap(ResettableIterator<T> theIterator, Comparator<T> theComparator) {
        if (theIterator instanceof SkippingIterator) {
            return (SkippingIterator)theIterator;
        }
        return new WrappingSkippingIterator<T, ResettableIterator<T>>(theIterator, theComparator);
    }

    @SafeVarargs
    @MustBeClosed
    public static <T> SkippingIterator<T> concat(SkippingIterator<T> ... theIterators) {
        if (theIterators == null || theIterators.length == 0) {
            return SkippingIterators.emptyIterator();
        }
        if (theIterators.length == 1) {
            return theIterators[0];
        }
        return new ConcatSkippingIterator<T>(SkippingIterators.resettableConcatIterator(theIterators), theIterators[0].comparator(), SkippingIterators.estimatedSize(theIterators));
    }

    @MustBeClosed
    public static <T> SkippingIterator<T> prepend(final T theFirst, final SkippingIterator<T> theIterator) {
        return new AbstractSkippingIterator<T>(theIterator.comparator()){
            boolean mFirst;
            {
                super(theComparator);
                this.mFirst = false;
            }

            @Override
            protected T computeNext() {
                if (!this.mFirst) {
                    this.mFirst = true;
                    return theFirst;
                }
                return theIterator.hasNext() ? theIterator.next() : this.endOfData();
            }

            @Override
            protected T computeSkipTo(T theTarget) {
                if (!this.mFirst) {
                    this.mFirst = true;
                    if (this.comparator().compare(theFirst, theTarget) >= 0) {
                        return theFirst;
                    }
                }
                return theIterator.skipTo(theTarget) ? (Object)theIterator.next() : null;
            }

            @Override
            protected void performReset() {
                this.mFirst = false;
                theIterator.reset();
            }

            @Override
            public long estimatedSize() {
                return theIterator.estimatedSize() + 1L;
            }

            @Override
            public void close() {
                super.close();
                theIterator.close();
            }
        };
    }

    @MustBeClosed
    public static <T> SkippingIterator<T> concat(ResettableIterator<SkippingIterator<T>> theIterators, Comparator<T> theComparator, long theEstimatedSize) {
        if (!theIterators.hasNext()) {
            return SkippingIterators.emptyIterator();
        }
        return new ConcatSkippingIterator<T>(theIterators, theComparator, theEstimatedSize);
    }

    private static long estimatedSize(SkippingIterator<?> ... theIterators) {
        long aEstimate = 0L;
        for (SkippingIterator<?> aIter : theIterators) {
            long aSize = aIter.estimatedSize();
            if (aSize == -1L) {
                return -1L;
            }
            aEstimate += aSize;
        }
        return aEstimate;
    }

    private static <T> ResettableIterator<SkippingIterator<T>> resettableConcatIterator(final SkippingIterator<T>[] theIterators) {
        return new ResettableIterator<SkippingIterator<T>>(){
            int mIndex = 0;

            @Override
            public boolean hasNext() {
                return this.mIndex < theIterators.length;
            }

            @Override
            public SkippingIterator<T> next() {
                return theIterators[this.mIndex++];
            }

            @Override
            public void remove() {
            }

            @Override
            public void close() {
            }

            @Override
            public void reset() {
                this.mIndex = 0;
            }
        };
    }

    @MustBeClosed
    public static <T> SkippingIterator<T> union(Comparator<T> theComparator, SkippingIterator<T> theIterator1, SkippingIterator<T> theIterator2) {
        return new NaryUnionSkippingIterator<Object>(theComparator, PICK_FIRST, theIterator1, theIterator2);
    }

    public static <T> Comparator<T> allEqual() {
        return (o1, o2) -> 0;
    }

    public static <T> SkippingIterator<T> union(Comparator<T> theComparator, SkippingIterator<T> ... theIterators) {
        if (theIterators.length == 0) {
            return SkippingIterators.emptyIterator();
        }
        if (theIterators.length == 1) {
            return theIterators[0];
        }
        return new NaryUnionSkippingIterator<Object>(theComparator, PICK_FIRST, theIterators);
    }

    public static <T> SkippingIterator<T> unionAll(Comparator<T> theComparator, SkippingIterator<T> ... theIterators) {
        switch (theIterators.length) {
            case 0: {
                return SkippingIterators.emptyIterator();
            }
            case 1: {
                return theIterators[0];
            }
        }
        return new NaryUnionSkippingIterator<T>(theComparator, null, theIterators);
    }

    public static <T> SkippingIterator<T> union(Comparator<T> theComparator, SkippingIterator<T> theIterator1, SkippingIterator<T> theIterator2, BiFunction<T, T, T> theMergeFunc) {
        return new NaryUnionSkippingIterator<T>(theComparator, theMergeFunc, theIterator1, theIterator2);
    }

    public static <T> PeekingSkippingIterator<T> emptyIterator() {
        return (PeekingSkippingIterator)EMPTY;
    }

    public static <T> SkippingIterator<T> singletonIterator(T theElement, Comparator<T> theComparator) {
        return SkippingIterators.wrap(ResettableIterators.fromIterable(Collections.singleton(theElement)), theComparator);
    }

    @MustBeClosed
    public static <T> PeekingSkippingIterator<T> peekingIterator(SkippingIterator<T> theIterator) {
        if (theIterator instanceof PeekingSkippingIterator) {
            return (PeekingSkippingIterator)theIterator;
        }
        return new PeekingSkippingIteratorImpl<T>(theIterator);
    }

    public static <T> SkippingIterator<T> appendCloseable(final SkippingIterator<T> iterator, final AutoCloseable toClose) {
        return new AbstractSkippingIterator<T>(iterator.comparator()){

            @Override
            protected T computeNext() {
                return iterator.hasNext() ? iterator.next() : this.endOfData();
            }

            @Override
            protected T computeSkipTo(T theTarget) {
                return iterator.skipTo(theTarget) ? iterator.next() : this.endOfData();
            }

            @Override
            protected void performReset() {
                iterator.reset();
            }

            @Override
            public void close() {
                AutoCloser.close(iterator, toClose);
            }
        };
    }

    public static <T extends Copyable<T>> SkippingIterator<T> copy(final SkippingIterator<T> iterator) {
        return new AbstractSkippingIterator<T>(iterator.comparator()){

            @Override
            protected T computeNext() {
                return iterator.hasNext() ? ((Copyable)iterator.next()).copy() : (Copyable)this.endOfData();
            }

            @Override
            protected T computeSkipTo(T theTarget) {
                return iterator.skipTo(theTarget) ? ((Copyable)iterator.next()).copy() : (Copyable)this.endOfData();
            }

            @Override
            protected void performReset() {
                iterator.reset();
            }

            @Override
            public void close() {
                iterator.close();
            }
        };
    }

    private static final class ArraySkippingIterator<T>
    extends AbstractSkippingIterator<T> {
        private final T[] mData;
        private final int mStart;
        private final int mEnd;
        private int mPos = -1;

        ArraySkippingIterator(T[] theData, Comparator<T> theComparator) {
            this(theData, 0, theData.length, theComparator);
        }

        ArraySkippingIterator(T[] theData, int theStart, int theEnd, Comparator<T> theComparator) {
            super(theComparator);
            this.mData = theData;
            this.mPos = this.mStart = theStart;
            this.mEnd = theEnd;
            Disposables.markCreated(this);
        }

        @Override
        public void close() {
            super.close();
            Disposables.markReleased(this);
        }

        @Override
        public long estimatedSize() {
            return this.mEnd - this.mStart;
        }

        @Override
        protected T computeNext() {
            return this.mPos < this.mEnd ? this.mData[this.mPos++] : this.endOfData();
        }

        @Override
        protected T computeSkipTo(T theTarget) {
            if (this.mPos < this.mEnd) {
                this.mPos = ArrayUtil.deferredEqualityBinarySearchAfter(this.mData, theTarget, this.mPos, this.mEnd, this.comparator());
                return this.computeNext();
            }
            return this.endOfData();
        }

        @Override
        protected void performReset() {
            this.mPos = this.mStart;
        }
    }

    private static final class RangeIterator<T>
    extends AbstractSkippingIterator<T>
    implements PeekingSkippingIterator<T> {
        private final PeekingSkippingIterator<T> mIterator;
        private boolean mInit;
        private final T mMinElement;
        private final T mMaxElement;

        @MustBeClosed
        private RangeIterator(SkippingIterator<T> theIterator, T theMinElement, T theMaxElement) {
            super(theIterator.comparator());
            Preconditions.checkArgument((theMinElement != null || theMaxElement != null ? 1 : 0) != 0, (Object)"No range specified");
            PeekingSkippingIterator<T> aPeekingIterator = SkippingIterators.peekingIterator(theIterator);
            this.mIterator = aPeekingIterator;
            this.mMaxElement = theMaxElement;
            this.mMinElement = theMinElement;
            this.mInit = this.mMinElement == null;
        }

        @Override
        public void close() throws RuntimeException {
            super.close();
            this.mIterator.close();
        }

        private T init() {
            this.mInit = true;
            if (this.mIterator.skipTo(this.mMinElement, this.mMaxElement)) {
                return (T)this.mIterator.peek();
            }
            return this.endOfData();
        }

        @Override
        protected T computeNext() {
            Object aCurr = this.mInit ? (this.mIterator.hasNext() ? this.mIterator.peek() : this.endOfData()) : this.init();
            if (aCurr == null || this.mMaxElement != null && this.comparator().compare(aCurr, this.mMaxElement) > 0) {
                return this.endOfData();
            }
            return (T)this.mIterator.next();
        }

        @Override
        protected T computeSkipTo(T theTarget) {
            Comparator<Object> aComp = this.comparator();
            if (!this.mInit) {
                this.mInit = true;
                T t = theTarget = aComp.compare(theTarget, this.mMinElement) < 0 ? this.mMinElement : theTarget;
            }
            if (this.mMaxElement != null && aComp.compare(theTarget, this.mMaxElement) > 0) {
                return this.endOfData();
            }
            if (!this.mIterator.skipTo(theTarget, this.mMaxElement)) {
                return this.endOfData();
            }
            Object next = this.mIterator.next();
            return (T)(this.mMaxElement == null || aComp.compare(next, this.mMaxElement) <= 0 ? next : this.endOfData());
        }

        @Override
        protected void performReset() {
            this.mIterator.reset();
            this.mInit = this.mMinElement == null;
        }
    }

    private static class FilteringSkippingIterator<T>
    extends AbstractSkippingIterator<T> {
        private final PeekingSkippingIterator<T> mIterator;
        private final Predicate<? super T> mFilter;

        private FilteringSkippingIterator(SkippingIterator<T> theIterator, Predicate<? super T> theFilter) {
            super(theIterator.comparator());
            this.mIterator = SkippingIterators.peekingIterator(theIterator);
            this.mFilter = theFilter;
        }

        @Override
        public void close() {
            AutoCloser.close(() -> super.close(), this.mIterator, () -> {
                if (this.mFilter instanceof ResettablePredicate) {
                    ((ResettablePredicate)this.mFilter).close();
                }
            });
        }

        @Override
        protected T computeNext() {
            while (this.mIterator.hasNext()) {
                Object current = this.mIterator.next();
                if (!this.mFilter.test(current)) continue;
                return (T)current;
            }
            return this.endOfData();
        }

        @Override
        protected T computeSkipTo(T theTarget) {
            return this.computeSkipTo(theTarget, null);
        }

        @Override
        protected T computeSkipTo(T theTarget, T theBound) {
            Object current;
            if (!this.mIterator.skipTo(theTarget, theBound)) {
                return null;
            }
            do {
                if (!this.mIterator.hasNext()) {
                    return this.endOfData();
                }
                current = this.mIterator.peek();
                if (this.isLessOrEqualThan(current, theBound)) continue;
                return null;
            } while (!this.mFilter.test(current = this.mIterator.next()));
            return (T)current;
        }

        @Override
        protected void performReset() {
            this.mIterator.reset();
            if (this.mFilter instanceof ResettablePredicate) {
                ((ResettablePredicate)this.mFilter).reset();
            }
        }

        @Override
        public long estimatedSize() {
            return this.mIterator.estimatedSize();
        }
    }

    private static final class DistinctSkippingIterator<T>
    extends PeekingSkippingIteratorImpl<T> {
        private T mPrev = null;

        @MustBeClosed
        private DistinctSkippingIterator(SkippingIterator<T> theIterator) {
            super(theIterator);
        }

        @Override
        protected T computeNext() {
            while (this.mIterator.hasNext()) {
                Object aNext = this.mIterator.next();
                if (aNext.equals(this.mPrev)) continue;
                this.mPrev = aNext;
                return (T)aNext;
            }
            return this.endOfData();
        }

        @Override
        protected T computeSkipTo(T theTarget) {
            this.mPrev = super.computeSkipTo(theTarget);
            return this.mPrev;
        }

        @Override
        protected void performReset() {
            super.performReset();
            this.mPrev = null;
        }
    }

    private static class TransformingSkippingIterator<I, T>
    extends AbstractSkippingIterator<T> {
        private final SkippingIterator<I> mIterator;
        private final Function<I, T> mFunction;
        private final Function<T, I> mInverseFunction;

        @MustBeClosed
        private TransformingSkippingIterator(SkippingIterator<I> theIterator, Comparator<T> theComparator, Function<I, T> theFunction, Function<T, I> theInverseFunction) {
            super(theComparator);
            this.mIterator = theIterator;
            this.mFunction = theFunction;
            this.mInverseFunction = theInverseFunction;
        }

        @Override
        public void close() throws RuntimeException {
            this.mIterator.close();
        }

        @Override
        protected T computeNext() {
            return this.mIterator.hasNext() ? this.mFunction.apply(this.mIterator.next()) : this.endOfData();
        }

        @Override
        protected T computeSkipTo(T theTarget) {
            if (!this.mIterator.skipTo(this.mInverseFunction.apply(theTarget))) {
                return null;
            }
            return this.mFunction.apply(this.mIterator.next());
        }

        @Override
        protected void performReset() {
            this.mIterator.reset();
        }

        @Override
        public long estimatedSize() {
            return this.mIterator.estimatedSize();
        }
    }

    private static class WrappingSkippingIterator<T, I extends ResettableIterator<T>>
    extends AbstractSkippingIterator<T> {
        protected final I mIter;

        @MustBeClosed
        WrappingSkippingIterator(I theIter, Comparator<T> theComparator) {
            super(theComparator);
            this.mIter = theIter;
            Disposables.markCreated(this);
        }

        @Override
        public void close() throws RuntimeException {
            Disposables.markReleased(this);
            this.mIter.close();
        }

        @Override
        protected T computeNext() {
            return (T)(this.mIter.hasNext() ? this.mIter.next() : this.endOfData());
        }

        @Override
        protected T computeSkipTo(T theTarget) {
            while (this.mIter.hasNext()) {
                Object aNext = this.mIter.next();
                if (this.mComparator.compare(aNext, theTarget) < 0) continue;
                return (T)aNext;
            }
            return this.endOfData();
        }

        @Override
        protected void performReset() {
            this.mIter.reset();
        }
    }

    private static class ConcatSkippingIterator<T>
    extends AbstractSkippingIterator<T> {
        private final ResettableIterator<SkippingIterator<T>> mSkipIterators;
        private final long mEstimatedSize;
        private SkippingIterator<T> mCurrentIter;

        @MustBeClosed
        ConcatSkippingIterator(ResettableIterator<SkippingIterator<T>> theIterators, Comparator<T> theComparator, long theEstimatedSize) {
            super(theComparator);
            this.mSkipIterators = theIterators;
            this.mEstimatedSize = theEstimatedSize;
            this.mCurrentIter = SkippingIterators.emptyIterator();
        }

        @Override
        public final void close() throws RuntimeException {
            AutoCloser closer = AutoCloser.create();
            this.mSkipIterators.reset();
            this.mSkipIterators.forEachRemaining(closer::register);
            try {
                closer.close();
            }
            finally {
                super.close();
            }
        }

        @Override
        protected T computeNext() {
            while (true) {
                if (this.mCurrentIter.hasNext()) {
                    return (T)this.mCurrentIter.next();
                }
                if (!this.mSkipIterators.hasNext()) break;
                this.mCurrentIter = (SkippingIterator)this.mSkipIterators.next();
            }
            return this.endOfData();
        }

        @Override
        protected T computeSkipTo(T theTarget) {
            while (true) {
                if (this.mCurrentIter.skipTo(theTarget)) {
                    return (T)this.mCurrentIter.next();
                }
                if (!this.mSkipIterators.hasNext()) break;
                this.mCurrentIter = (SkippingIterator)this.mSkipIterators.next();
            }
            return this.endOfData();
        }

        @Override
        protected void performReset() {
            this.mSkipIterators.reset();
            this.mSkipIterators.forEachRemaining(ResettableIterator::reset);
            this.mSkipIterators.reset();
            this.mCurrentIter = SkippingIterators.emptyIterator();
        }

        @Override
        public long estimatedSize() {
            return this.mEstimatedSize;
        }
    }

    private static class PeekingSkippingIteratorImpl<T>
    extends AbstractSkippingIterator<T> {
        protected final SkippingIterator<T> mIterator;

        @MustBeClosed
        private PeekingSkippingIteratorImpl(SkippingIterator<T> theIterator) {
            super(theIterator.comparator());
            this.mIterator = theIterator;
        }

        @Override
        public void close() {
            super.close();
            this.mIterator.close();
        }

        @Override
        public long estimatedSize() {
            return this.mIterator.estimatedSize();
        }

        @Override
        protected T computeNext() {
            return (T)(this.mIterator.hasNext() ? this.mIterator.next() : this.endOfData());
        }

        @Override
        protected T computeSkipTo(T theTarget) {
            return this.mIterator.skipTo(theTarget) ? (T)this.mIterator.next() : null;
        }

        @Override
        protected void performReset() {
            this.mIterator.reset();
        }
    }
}

