/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposables;
import com.complexible.common.collect.ResettableIterator;
import java.util.Iterator;

public final class ResettableIterators {
    public static <T> ResettableIterator<T> fromIterable(Iterable<T> theIterable) {
        return ResettableIterators.fromIterable(theIterable, () -> {});
    }

    public static <T> ResettableIterator<T> fromIterable(Iterable<T> theIterable, Runnable theCloser) {
        return new ConcreteResettableIterator<T>(theIterable, theCloser);
    }

    private static final class ConcreteResettableIterator<T>
    implements ResettableIterator<T> {
        private final Iterable<T> theIterable;
        private Iterator<T> mIter;
        private final Runnable theCloser;

        ConcreteResettableIterator(Iterable<T> iter, Runnable closer) {
            this.theIterable = iter;
            this.mIter = this.theIterable.iterator();
            this.theCloser = closer;
            Disposables.markCreated(this);
        }

        @Override
        public void close() throws RuntimeException {
            Disposables.markReleased(this);
            if (this.mIter instanceof AutoCloseable) {
                AutoCloser.close((AutoCloseable)((Object)this.mIter));
            }
            if (this.theCloser != null) {
                this.theCloser.run();
            }
        }

        @Override
        public boolean hasNext() {
            return this.mIter.hasNext();
        }

        @Override
        public T next() {
            return this.mIter.next();
        }

        @Override
        public void remove() {
            this.mIter.remove();
        }

        @Override
        public void reset() {
            this.mIter = this.theIterable.iterator();
        }
    }
}

