/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;

public class NestedList<T>
implements Iterable<T> {
    private static NestedList<Object> NIL = new NestedList<Object>(null, null);
    private final NestedList<T> rest;
    private final T first;
    private final int size;

    public static <T> NestedList<T> nil() {
        return NIL;
    }

    public static <T> NestedList<T> singleton(T element) {
        return new NestedList<T>(element, NestedList.nil());
    }

    public static <T> NestedList<T> create(T first, NestedList<T> rest) {
        Preconditions.checkNotNull(rest);
        return new NestedList<T>(first, rest);
    }

    public static <T> NestedList<T> concat(Iterable<T> begin, NestedList<T> end) {
        return NestedList.concat(begin.iterator(), end);
    }

    public static <T> NestedList<T> concat(Iterator<T> begin, NestedList<T> end) {
        return begin.hasNext() ? NestedList.create(begin.next(), NestedList.concat(begin, end)) : end;
    }

    private NestedList(T first, NestedList<T> rest) {
        this.first = first;
        this.rest = rest;
        this.size = rest == null ? 0 : rest.size + 1;
    }

    public T first() {
        return this.first;
    }

    public NestedList<T> rest() {
        return this.rest;
    }

    public boolean isNil() {
        return this == NIL;
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<T> iterator() {
        return new UnmodifiableIterator<T>(){
            private NestedList<T> curr;
            {
                this.curr = NestedList.this;
            }

            public boolean hasNext() {
                return !this.curr.isNil();
            }

            public T next() {
                Object value = this.curr.first;
                this.curr = this.curr.rest;
                return value;
            }
        };
    }

    public String toString() {
        return Iterables.toString((Iterable)this);
    }
}

