/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.collect.AbstractSkippingIterator;
import com.complexible.common.collect.SkippingIterator;
import java.util.Comparator;
import java.util.function.BiFunction;

final class NaryUnionSkippingIterator<T>
extends AbstractSkippingIterator<T> {
    static final BiFunction NO_DUPLICATE_ELIMINATION = null;
    private final SkippingIterator<T>[] mIterators;
    private final BiFunction<T, T, T> mPicker;
    private T[] mHeads;
    private int mNextIndex;

    NaryUnionSkippingIterator(Comparator<T> theComparator, SkippingIterator<T> ... theIterators) {
        this(theComparator, NO_DUPLICATE_ELIMINATION, theIterators);
    }

    NaryUnionSkippingIterator(Comparator<T> theComparator, BiFunction<T, T, T> thePicker, SkippingIterator<T> ... theIterators) {
        super(theComparator);
        this.mIterators = theIterators;
        this.mNextIndex = -1;
        this.mPicker = thePicker;
    }

    private void init(T theTarget) {
        this.mHeads = new Object[this.mIterators.length];
        for (int i = 0; i < this.mHeads.length; ++i) {
            T head;
            T t = head = theTarget == null ? this.nextHead(i) : this.skipToHead(i, theTarget);
            if (head == null) continue;
            this.mHeads[i] = head;
            this.selectSmallest(i);
        }
    }

    private T skipTo(SkippingIterator<T> iterator, T target, T bound) {
        return iterator.skipTo(target, bound) ? (T)iterator.next() : null;
    }

    private T skipToHead(int i, T theTarget) {
        return this.skipTo(this.mIterators[i], theTarget, null);
    }

    private T nextHead(int i) {
        SkippingIterator<T> iterator = this.mIterators[i];
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    @Override
    protected T computeNext() {
        if (this.mHeads == null) {
            this.init(null);
            return this.consumeSmallest();
        }
        this.mHeads[this.mNextIndex] = this.nextHead(this.mNextIndex);
        this.mNextIndex = -1;
        for (int i = 0; i < this.mHeads.length; ++i) {
            T head = this.advance(i);
            if (head == null) continue;
            this.selectSmallest(i);
        }
        return this.consumeSmallest();
    }

    private T advance(int index) {
        T head = this.mHeads[index];
        if (head == null) {
            this.mHeads[index] = this.nextHead(index);
            return this.mHeads[index];
        }
        return head;
    }

    private void selectSmallest(int index) {
        if (this.mHeads[index] == null) {
            return;
        }
        if (this.mNextIndex < 0) {
            this.mNextIndex = index;
            return;
        }
        int cmp = this.mComparator.compare(this.mHeads[this.mNextIndex], this.mHeads[index]);
        if (cmp > 0) {
            this.mNextIndex = index;
        } else if (cmp == 0 && this.mPicker != null) {
            this.mHeads[this.mNextIndex] = this.mPicker.apply(this.mHeads[this.mNextIndex], this.mHeads[index]);
            this.mHeads[index] = null;
        }
    }

    private T consumeSmallest() {
        if (this.mNextIndex < 0) {
            return this.endOfData();
        }
        T next = this.mHeads[this.mNextIndex];
        this.mHeads[this.mNextIndex] = null;
        return next;
    }

    @Override
    protected T computeSkipTo(T theTarget) {
        return this.computeSkipTo(theTarget, null);
    }

    @Override
    protected T computeSkipTo(T target, T bound) {
        if (this.mHeads == null) {
            this.init(target);
            return this.consumeSmallest();
        }
        this.mHeads[this.mNextIndex] = this.skipTo(this.mIterators[this.mNextIndex], target, bound);
        this.mNextIndex = -1;
        for (int i = 0; i < this.mHeads.length; ++i) {
            int cmp;
            T head = this.mHeads[i];
            int n = cmp = head == null ? 1 : this.mComparator.compare(target, head);
            if (cmp > 0) {
                this.mHeads[i] = this.skipTo(this.mIterators[i], target, bound);
            }
            this.selectSmallest(i);
        }
        return this.consumeSmallest();
    }

    @Override
    public void close() {
        AutoCloser.close(this.mIterators);
    }

    @Override
    protected void performReset() {
        for (SkippingIterator<T> iterator : this.mIterators) {
            iterator.reset();
        }
        this.mHeads = null;
        this.mNextIndex = -1;
    }

    @Override
    public long estimatedSize() {
        long size = 0L;
        for (SkippingIterator<T> iterator : this.mIterators) {
            long itSize = iterator.estimatedSize();
            if (itSize == -1L) {
                return -1L;
            }
            size += itSize;
        }
        return size;
    }
}

