/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.complexible.common.base.CloseableIterator;
import com.complexible.common.collect.SkippingIterator;
import com.complexible.common.collect.SkippingLongIterator;
import com.complexible.common.primitives.AbstractLongIterator;
import com.complexible.common.primitives.AbstractSkippingLongIterator;
import com.complexible.common.primitives.ArrayUtil;
import com.complexible.common.primitives.CloseableLongIterator;
import com.complexible.common.primitives.LongIterator;
import com.complexible.common.primitives.ResettableLongIterator;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.ToLongFunction;

public class LongIterators {
    private static final SkippingLongIterator EMPTY = new SkippingLongIterator(){

        @Override
        public long next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public long peek() {
            throw new NoSuchElementException();
        }

        @Override
        public void reset() {
        }

        @Override
        public boolean skipTo(long theValue) {
            return false;
        }
    };

    public static LongIterator concat(final LongIterator theFirst, final LongIterator theSecond) {
        return new LongIterator(){
            boolean mFirstDone = false;

            @Override
            public boolean hasNext() {
                if (this.mFirstDone) {
                    return theSecond.hasNext();
                }
                if (theFirst.hasNext()) {
                    return true;
                }
                this.mFirstDone = true;
                return theSecond.hasNext();
            }

            @Override
            public long next() {
                return this.mFirstDone ? theSecond.next() : theFirst.next();
            }
        };
    }

    public static SkippingLongIterator emptyIterator() {
        return EMPTY;
    }

    public static ResettableLongIterator singleton(long theValue) {
        return new SingletonLongIterator(theValue);
    }

    public static SkippingLongIterator forArray(long[] theArray, int theStart, int theEnd) {
        return theEnd - theStart < 100 ? new LinearSearchArrayLongIterator(theArray, theStart, theEnd) : new BinarySearchArrayLongIterator(theArray, theStart, theEnd);
    }

    public static SkippingLongIterator forArray(long ... theArray) {
        return LongIterators.forArray(theArray, 0, theArray.length);
    }

    public static SkippingLongIterator forRange(final long theInitialValue, final long theFinalValue) {
        return new SkippingLongIterator(){
            private long mNext;
            {
                this.mNext = theInitialValue;
            }

            @Override
            public boolean hasNext() {
                return this.mNext <= theFinalValue;
            }

            @Override
            public long next() {
                return this.mNext++;
            }

            @Override
            public long peek() {
                return this.mNext;
            }

            @Override
            public void reset() {
                this.mNext = theInitialValue;
            }

            @Override
            public boolean skipTo(long theElement) {
                if (theElement >= this.mNext) {
                    this.mNext = theElement + 1L;
                }
                return this.hasNext();
            }
        };
    }

    public static <T> SkippingLongIterator forSkippingIterator(final SkippingIterator<T> theIterator, final ToLongFunction<T> theObjectToLong, final LongFunction<T> theLongToObject) {
        return new AbstractSkippingLongIterator(){

            @Override
            public long computeSkipTo(long theValue) {
                Object aTarget = theLongToObject.apply(theValue);
                return !theIterator.skipTo(aTarget) ? this.endOfData() : theObjectToLong.applyAsLong(theIterator.next());
            }

            @Override
            protected long computeNext() {
                if (theIterator.hasNext()) {
                    Object aObj = theIterator.next();
                    return theObjectToLong.applyAsLong(aObj);
                }
                return this.endOfData();
            }

            @Override
            protected void performReset() {
                theIterator.reset();
            }

            @Override
            public void close() {
                theIterator.close();
            }
        };
    }

    public static <T> CloseableIterator<T> toIterator(final CloseableLongIterator theIter, final LongFunction<T> theFunc) {
        return new CloseableIterator.AbstractCloseableIterator<T>(){

            protected T computeNext() {
                if (theIter.hasNext()) {
                    long aNext = theIter.next();
                    return theFunc.apply(aNext);
                }
                return this.endOfData();
            }

            @Override
            public void close() throws RuntimeException {
                theIter.close();
            }
        };
    }

    public static <T> CloseableLongIterator fromIterator(final CloseableIterator<T> theIter, final ToLongFunction<T> theFunc) {
        return new AbstractLongIterator(){

            @Override
            protected long computeNext() {
                if (theIter.hasNext()) {
                    Object aNext = theIter.next();
                    return theFunc.applyAsLong(aNext);
                }
                return this.endOfData();
            }

            @Override
            protected void performReset() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                theIter.close();
            }
        };
    }

    public static long size(LongIterator theIter) {
        long aSize = 0L;
        while (theIter.hasNext()) {
            ++aSize;
            theIter.next();
        }
        return aSize;
    }

    public static List<Long> toList(final LongIterator theIter) {
        return Lists.newArrayList((Iterator)new AbstractIterator<Long>(){

            protected Long computeNext() {
                return theIter.hasNext() ? Long.valueOf(theIter.next()) : (Long)this.endOfData();
            }
        });
    }

    public static CloseableLongIterator uncloseable(final CloseableLongIterator iterator) {
        return new CloseableLongIterator(){

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public long next() {
                return iterator.next();
            }
        };
    }

    public static SkippingLongIterator filtered(final SkippingLongIterator base, final LongPredicate predicate) {
        return new AbstractSkippingLongIterator(){

            @Override
            public long computeSkipTo(long target) {
                if (!base.skipTo(target)) {
                    return Long.MIN_VALUE;
                }
                return this.computeNext();
            }

            @Override
            protected long computeNext() {
                long next;
                do {
                    if (base.hasNext()) continue;
                    return Long.MIN_VALUE;
                } while (!predicate.test(next = base.next()));
                return next;
            }

            @Override
            protected void performReset() {
                base.reset();
            }
        };
    }

    private static class SingletonLongIterator
    implements ResettableLongIterator {
        private final long mValue;
        private boolean mReturned = false;

        SingletonLongIterator(long theValue) {
            this.mValue = theValue;
        }

        @Override
        public void reset() {
            this.mReturned = false;
        }

        @Override
        public boolean hasNext() {
            return !this.mReturned;
        }

        @Override
        public long next() {
            if (this.mReturned) {
                throw new NoSuchElementException();
            }
            this.mReturned = true;
            return this.mValue;
        }
    }

    private static class LinearSearchArrayLongIterator
    extends ArrayLongIterator {
        public LinearSearchArrayLongIterator(long[] theData, int theBegin, int theEnd) {
            super(theData, theBegin, theEnd);
        }

        @Override
        public boolean skipTo(long theElement) {
            while (this.hasNext() && this.mData[this.mPos] < theElement) {
                ++this.mPos;
            }
            return this.hasNext();
        }
    }

    private static class BinarySearchArrayLongIterator
    extends ArrayLongIterator {
        BinarySearchArrayLongIterator(long[] theData, int theBegin, int theEnd) {
            super(theData, theBegin, theEnd);
        }

        @Override
        public boolean skipTo(long theElement) {
            this.mPos = Arrays.binarySearch(this.mData, this.mPos, this.mEnd, theElement);
            if (this.mPos < 0) {
                this.mPos = ArrayUtil.normalizeAfter(this.mPos);
            }
            return this.hasNext();
        }
    }

    private static abstract class ArrayLongIterator
    implements SkippingLongIterator {
        protected long[] mData;
        protected int mPos = 0;
        protected int mEnd = 0;

        ArrayLongIterator(long[] theData, int theBegin, int theEnd) {
            this.mData = theData;
            this.mPos = theBegin;
            this.mEnd = theEnd;
        }

        @Override
        public boolean hasNext() {
            return this.mPos < this.mEnd;
        }

        @Override
        public long next() {
            return this.mData[this.mPos++];
        }

        @Override
        public long peek() {
            return this.mData[this.mPos];
        }

        @Override
        public void reset() {
            this.mPos = 0;
        }
    }
}

