/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.complexible.common.collect.BufferList;
import com.complexible.common.collect.ExtendedBufferList;
import com.complexible.common.collect.SortedIterators;
import com.complexible.common.primitives.ArrayUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;

public class BufferLists {
    public static <T> BufferList<T> fixed(int theMaxSize) {
        return new FixedBufferList(theMaxSize, theMaxSize);
    }

    private static void assertInitialSize(int theInitSize, int theMaxSize) {
        if (theInitSize > theMaxSize) {
            throw new IllegalArgumentException(String.format("Initial size (%d) should be less than or equal to max size (%d)", theInitSize, theMaxSize));
        }
    }

    public static <T> BufferList<T> limited(int theInitSize, int theMaxSize) {
        BufferLists.assertInitialSize(theInitSize, theMaxSize);
        return theInitSize == theMaxSize ? BufferLists.fixed(theMaxSize) : new LimitedBufferList(theInitSize, theMaxSize);
    }

    public static <T> BufferList<T> unlimited(int theInitSize) {
        return new LimitedBufferList(theInitSize, Integer.MAX_VALUE);
    }

    public static <T> BufferList<T> fixed(T ... theArray) {
        return new FixedBufferList<T>(theArray, theArray.length, theArray.length);
    }

    public static <T> BufferList<T> fixedEmpty(T[] theArray) {
        return new FixedBufferList<T>(theArray, 0, theArray.length);
    }

    public static <T> BufferList<T> limited(T[] theArray, int theMaxSize) {
        return new LimitedBufferList<T>(theArray, theArray.length, theMaxSize);
    }

    public static <T> BufferList<T> limitedWithExpectedSize(int theExpectedSize) {
        return BufferLists.limitedWithExpectedSize(theExpectedSize, 0x100000);
    }

    public static <T> BufferList<T> limitedWithExpectedSize(int theExpectedSize, int maxSize) {
        int minSize = Math.min(Math.max(theExpectedSize, 256), maxSize);
        return BufferLists.limited(minSize, maxSize);
    }

    public static <T> ExtendedBufferList<T> sortedLimited(int theExpectedSize) {
        int maxSize = 0x100000;
        int minSize = Math.min(Math.max(theExpectedSize, 256), maxSize);
        return minSize == maxSize ? new SortedFixedBufferList(minSize, maxSize) : new SortedLimitedBufferList(minSize, maxSize);
    }

    public static <T> ExtendedBufferList<T> sortedUnlimited(int theInitSize) {
        return new SortedLimitedBufferList(theInitSize, Integer.MAX_VALUE);
    }

    public static <T> BufferList<T> unlimited(T[] theArray) {
        return new LimitedBufferList<T>(theArray, theArray.length, Integer.MAX_VALUE);
    }

    public static <T> List<T> asJavaList(BufferList<T> buffer) {
        return Arrays.asList(buffer.array()).subList(0, buffer.size());
    }

    private static class FixedBufferList<T>
    extends AbstractCollection<T>
    implements BufferList<T> {
        protected final int maxSize;
        protected T[] data;
        protected int size;

        public FixedBufferList(int initSize, int maxSize) {
            this(ArrayUtil.newArray(initSize), 0, maxSize);
        }

        public FixedBufferList(T[] data, int currSize, int maxSize) {
            this.data = data;
            this.size = currSize;
            this.maxSize = maxSize;
        }

        @Override
        public T getAt(int index) {
            return this.data[index];
        }

        @Override
        public boolean add(T element) {
            this.data[this.size++] = element;
            return this.size == this.data.length;
        }

        @Override
        public boolean addAll(BufferList<T> buffer, int fromIndex, int length) {
            assert (length <= buffer.size() - fromIndex) : "Not enough elements in the source buffer";
            System.arraycopy(buffer.array(), fromIndex, this.data, this.size, length);
            this.size += length;
            return this.size == this.data.length;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean isFull() {
            return this.size == this.maxSize;
        }

        @Override
        public void clear() {
            this.size = 0;
        }

        @Override
        public void truncate(int newSize) {
            this.size = newSize;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int capacity() {
            return this.maxSize;
        }

        @Override
        public <E extends T> E[] array() {
            return this.data;
        }

        @Override
        @Nonnull
        public PeekingIterator<T> iterator() {
            return ArrayUtil.iterator(this.data, 0, this.size);
        }

        @Override
        public BufferList<T> sort(Comparator<? super T> theComparator) {
            ArrayUtil.sort(this.data, 0, this.size, theComparator);
            return this;
        }

        @Override
        public Object[] toArray() {
            return Arrays.copyOf(this.data, this.size);
        }

        @Override
        public String toString() {
            int limit = 1000;
            StringBuilder sb = new StringBuilder();
            sb.append("BufferList(").append(this.size).append(")[");
            Joiner.on((String)",").appendTo(sb, Iterators.limit(this.iterator(), (int)limit));
            if (this.size > limit) {
                sb.append(",...");
            }
            sb.append("]");
            return sb.toString();
        }
    }

    private static class LimitedBufferList<T>
    extends FixedBufferList<T> {
        public LimitedBufferList(int initSize, int maxSize) {
            super(initSize, maxSize);
        }

        public LimitedBufferList(T[] data, int currSize, int maxSize) {
            super(data, currSize, maxSize);
        }

        @Override
        public boolean add(T element) {
            if (this.size == this.data.length && this.size < this.maxSize) {
                this.data = ArrayUtil.increaseSize(this.data);
            }
            this.data[this.size++] = element;
            return this.size == this.maxSize;
        }

        @Override
        public boolean addAll(BufferList<T> buffer, int fromIndex, int length) {
            assert (length <= buffer.size() - fromIndex) : "Not enough elements in the source buffer";
            int newSize = this.size + length;
            if (newSize > this.data.length && newSize <= this.maxSize) {
                this.data = ArrayUtil.ensureSize(this.data, newSize);
            }
            System.arraycopy(buffer.array(), fromIndex, this.data, this.size, length);
            this.size += length;
            return this.size == this.maxSize;
        }
    }

    private static class SortedFixedBufferList<T>
    extends FixedBufferList<T>
    implements ExtendedBufferList<T> {
        protected Comparator<? super T> lastComparator;
        protected boolean sorted = true;
        protected boolean unique = true;
        private static final int LARGE_ADD_COEFFICIENT = 100;
        private static final long LARGE_SORTED_BUFFER = 8192L;

        public SortedFixedBufferList(int initSize, int maxSize) {
            super(initSize, maxSize);
        }

        @Override
        public boolean add(T element) {
            if (!this.sorted || (long)this.size < 8192L) {
                this.unique = false;
                this.sorted = false;
                this.lastComparator = null;
                return super.add(element);
            }
            if (SortedInsert.one(this.data, this.size, element, this.lastComparator)) {
                ++this.size;
            }
            return this.size == this.data.length;
        }

        @Override
        public boolean addAll(BufferList<T> buffer, int fromIndex, int length) {
            if (!this.sorted || length * 100 > this.size) {
                this.sorted = false;
                this.unique = false;
                this.lastComparator = null;
                return super.addAll(buffer, fromIndex, length);
            }
            this.size += SortedInsert.many(this.data, this.size, buffer.array(), fromIndex, length, this.lastComparator);
            return this.size == this.data.length;
        }

        @Override
        public ExtendedBufferList<T> sort(Comparator<? super T> theComparator) {
            if (!this.sorted || theComparator != this.lastComparator) {
                this.lastComparator = theComparator;
                this.sorted = true;
                return (ExtendedBufferList)super.sort(theComparator);
            }
            return this;
        }

        @Override
        public void filterDuplicates() {
            if (this.unique) {
                return;
            }
            if (!this.sorted && this.size > 0) {
                throw new IllegalStateException("The buffer list must be sorted first");
            }
            int newSize = ArrayUtil.removeDuplicates(this.data, this.size);
            this.unique = true;
            this.truncate(newSize);
        }

        @Override
        public PeekingIterator<T> uniqueIterator() {
            if (this.unique || this.size == 0) {
                return this.iterator();
            }
            if (!this.sorted && this.size > 0) {
                throw new IllegalStateException("The buffer list must be sorted first");
            }
            return SortedIterators.uniqueIterator(this.iterator(), this.lastComparator);
        }

        @Override
        public void clear() {
            super.clear();
            this.sorted = true;
            this.unique = true;
        }
    }

    private static class SortedLimitedBufferList<T>
    extends SortedFixedBufferList<T> {
        public SortedLimitedBufferList(int initSize, int maxSize) {
            super(initSize, maxSize);
        }

        @Override
        public boolean add(T element) {
            if (this.size == this.data.length && this.size < this.maxSize) {
                this.data = ArrayUtil.increaseSize(this.data);
            }
            super.add(element);
            return this.size == this.maxSize;
        }

        @Override
        public boolean addAll(BufferList<T> buffer, int fromIndex, int length) {
            assert (length <= buffer.size() - fromIndex) : "Not enough elements in the source buffer";
            int newSize = this.size + length;
            if (newSize > this.data.length && newSize <= this.maxSize) {
                this.data = ArrayUtil.ensureSize(this.data, newSize);
            }
            super.addAll(buffer, fromIndex, length);
            return this.size == this.maxSize;
        }
    }

    private static class SortedInsert {
        private SortedInsert() {
        }

        static <T> boolean one(T[] data, int size, T element, Comparator<? super T> comparator) {
            int pos = ArrayUtil.search(data, element, 0, size, comparator);
            if (pos >= 0) {
                return false;
            }
            if ((pos = ArrayUtil.normalizeAfter(pos)) < size) {
                System.arraycopy(data, pos, data, pos + 1, size - pos);
            }
            data[pos] = element;
            return true;
        }

        static <T> int many(T[] data, int size, T[] elements, int elementsOffset, int elementSize, Comparator<? super T> comparator) {
            assert (elementsOffset >= 0) : "elementsOffset must be non-negative";
            assert (elementsOffset + elementSize <= elements.length) : "Not enough elements in the source array";
            int added = 0;
            for (int i = elementsOffset; i < elementSize; ++i) {
                if (i > elementsOffset && comparator.compare(elements[i], elements[i - 1]) == 0 || !SortedInsert.one(data, size, elements[i], comparator)) continue;
                ++size;
                ++added;
            }
            return added;
        }
    }
}

