/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.commons.lang3.mutable.MutableInt;

public class BatchingIterator<T>
extends AbstractIterator<Iterator<T>> {
    private final Iterator<T> mSource;
    private final Predicate<T> mBatchPredicate;
    private boolean mActiveIterator;
    private T mNext;

    public BatchingIterator(Iterator<T> sourceIterator, Predicate<T> theBatchPredicate) {
        this.mSource = sourceIterator;
        this.mBatchPredicate = theBatchPredicate;
    }

    protected Iterator<T> computeNext() {
        Preconditions.checkState((!this.mActiveIterator ? 1 : 0) != 0, (Object)"Cannot start a new batch until previous batch is exhausted");
        if (this.mNext == null && !this.mSource.hasNext()) {
            return (Iterator)this.endOfData();
        }
        this.mActiveIterator = true;
        return new AbstractIterator<T>(){

            protected T computeNext() {
                Object next;
                if (BatchingIterator.this.mNext != null) {
                    next = BatchingIterator.this.mNext;
                    BatchingIterator.this.mNext = null;
                } else {
                    if (!BatchingIterator.this.mSource.hasNext()) {
                        BatchingIterator.this.mActiveIterator = false;
                        return this.endOfData();
                    }
                    next = BatchingIterator.this.mSource.next();
                }
                if (!BatchingIterator.this.mBatchPredicate.test(next)) {
                    BatchingIterator.this.mNext = next;
                    BatchingIterator.this.mActiveIterator = false;
                    return this.endOfData();
                }
                return next;
            }
        };
    }

    public static <T> Iterator<Iterator<T>> sized(Iterator<T> source, int size) {
        MutableInt currBatchCount = new MutableInt(0);
        return new BatchingIterator<Object>(source, e -> {
            if (currBatchCount.incrementAndGet() > size) {
                currBatchCount.setValue(0);
                return false;
            }
            return true;
        });
    }
}

