/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.google.common.collect.PeekingIterator;
import com.google.common.collect.UnmodifiableIterator;

public final class ArrayIterator<T>
extends UnmodifiableIterator<T>
implements PeekingIterator<T> {
    private final T[] mArray;
    private final int mEnd;
    private int mPos = 0;

    public ArrayIterator(T[] theArray) {
        this(theArray, 0, theArray.length);
    }

    public ArrayIterator(T[] theArray, int theStart, int theEnd) {
        if (theStart < 0) {
            throw new ArrayIndexOutOfBoundsException(theStart);
        }
        if (theEnd > theArray.length) {
            throw new ArrayIndexOutOfBoundsException(theEnd);
        }
        this.mArray = theArray;
        this.mEnd = theEnd;
        this.mPos = theStart;
    }

    @SafeVarargs
    public static <T> ArrayIterator<T> create(T ... theElements) {
        return new ArrayIterator<T>(theElements);
    }

    public boolean hasNext() {
        return this.mPos < this.mEnd;
    }

    public T next() {
        return this.mArray[this.mPos++];
    }

    public T peek() {
        return this.mArray[this.mPos];
    }
}

