/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.complexible.common.base.CloseableIterator;
import com.complexible.common.collect.PeekingSkippingIterator;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.NoSuchElementException;

public abstract class AbstractSkippingIterator<T>
implements PeekingSkippingIterator<T>,
CloseableIterator<T> {
    private State state = State.NOT_READY;
    private T next;
    protected final Comparator<T> mComparator;

    public AbstractSkippingIterator(Comparator<T> theComparator) {
        assert (theComparator != null);
        this.mComparator = theComparator;
    }

    @Override
    public Comparator<T> comparator() {
        return this.mComparator;
    }

    @Override
    public long estimatedSize() {
        return -1L;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract T computeNext();

    protected abstract T computeSkipTo(T var1);

    protected T computeSkipTo(T theTarget, T theBound) {
        T result = this.computeSkipTo(theTarget);
        if (!this.isLessOrEqualThan(result, theBound)) {
            this.state = State.BEYOND_BOUND;
        }
        return result;
    }

    public boolean isLessOrEqualThan(T theElement, T theBound) {
        return theElement != null && (theBound == null || this.mComparator.compare(theElement, theBound) <= 0);
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        return this.next;
    }

    protected final T endOfData() {
        this.next = null;
        if (this.state != State.CLOSED) {
            this.state = State.DONE;
        }
        return null;
    }

    @Override
    public final boolean hasNext() {
        block7: while (true) {
            switch (this.state.ordinal()) {
                case 0: {
                    return false;
                }
                case 3: {
                    this.assertOpen();
                    return false;
                }
                case 1: {
                    return true;
                }
                case 2: 
                case 5: {
                    return this.tryToComputeNext();
                }
                case 4: {
                    this.performReset();
                    this.state = State.NOT_READY;
                    continue block7;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    private boolean tryToComputeNext() {
        this.next = this.computeNext();
        switch (this.state.ordinal()) {
            case 0: 
            case 3: {
                return false;
            }
        }
        this.state = State.READY;
        return true;
    }

    private boolean tryToSkip(T theTarget, T theBound) {
        this.next = this.computeSkipTo(theTarget, theBound);
        if (this.next != null) {
            switch (this.state.ordinal()) {
                case 5: {
                    this.state = State.READY;
                    return false;
                }
            }
            this.state = State.READY;
            return true;
        }
        if (theBound == null) {
            this.endOfData();
        } else {
            this.state = State.NOT_READY;
        }
        return false;
    }

    @Override
    public void close() {
        this.state = State.CLOSED;
    }

    public final T peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    @Override
    public final boolean skipTo(T theElement) {
        return this.skipTo(theElement, null);
    }

    @Override
    public final boolean skipTo(T theElement, T theBound) {
        assert (this.isLessOrEqualThan(theElement, theBound));
        block7: while (true) {
            switch (this.state.ordinal()) {
                case 0: {
                    return false;
                }
                case 1: {
                    if (this.mComparator.compare(this.next, theElement) >= 0) {
                        return true;
                    }
                    this.state = State.NOT_READY;
                    continue block7;
                }
                case 3: {
                    this.assertOpen();
                    return false;
                }
                case 2: {
                    this.validateSkipTarget(theElement);
                    return this.tryToSkip(theElement, theBound);
                }
                case 4: {
                    if (this.next == null || this.mComparator.compare(this.next, theElement) >= 0) {
                        this.performReset();
                    }
                    this.state = State.NOT_READY;
                    continue block7;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    protected void validateSkipTarget(T theTarget) {
    }

    @Override
    public final void reset() {
        this.assertOpen();
        this.state = State.LAZY_RESET;
    }

    protected boolean isClosed() {
        return this.state == State.CLOSED;
    }

    protected void assertOpen() {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)("The iterator has been closed: " + this.getClass().getSimpleName()));
    }

    protected final void resetState() {
        this.state = State.NOT_READY;
    }

    protected abstract void performReset();

    private static enum State {
        DONE,
        READY,
        NOT_READY,
        CLOSED,
        LAZY_RESET,
        BEYOND_BOUND;

    }
}

