/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.cancellation;

import com.complexible.common.cancellation.CancellationPoint;
import com.google.common.base.Preconditions;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class DummyCancellationPoint
implements CancellationPoint {
    private final AtomicReference<String> mCause = new AtomicReference<Object>(null);

    @Override
    public String getProcessDescription() {
        return "dummy";
    }

    @Override
    public void check() {
        if (this.mCause.get() != null) {
            throw new CancellationException(this.mCause.get());
        }
    }

    @Override
    public boolean isCancelled() {
        return this.mCause.get() != null;
    }

    @Override
    public void cancel() {
        this.cancel("Cancelled");
    }

    @Override
    public void cancel(String theCause) {
        Preconditions.checkNotNull((Object)theCause);
        this.mCause.compareAndSet(null, theCause);
    }

    @Override
    public String getCancellationMessage() {
        return this.mCause.get();
    }

    @Override
    public void wait(long timeout, TimeUnit unit) {
    }

    @Override
    public void close() {
    }
}

