/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.cancellation;

import com.complexible.common.cancellation.CancellationManager;
import com.complexible.common.cancellation.CancellationPoint;
import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultCancellationPoint
implements CancellationPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCancellationPoint.class);
    private static final String CLOSED_MSG = "Cancellation point is closed";
    private final String mDatabaseName;
    private final String mProcessDescription;
    private final Throwable mThrowable;
    private final CompletableFuture<Boolean> mRootFuture;
    private final CancellationManager mCancellationManager;
    private final Function<String, ? extends RuntimeException> mCancellationThrower;
    private final AtomicReference<String> mCause = new AtomicReference<Object>(null);

    DefaultCancellationPoint(String theProcessDescription, CancellationManager theCancellationManager, String theDatabaseName, Function<String, ? extends RuntimeException> theCancellationThrower) {
        this.mDatabaseName = theDatabaseName;
        this.mRootFuture = new CompletableFuture();
        this.mProcessDescription = theProcessDescription;
        this.mCancellationThrower = theCancellationThrower;
        this.mCancellationManager = theCancellationManager;
        this.mThrowable = new RuntimeException("");
    }

    @Override
    @Nullable
    public String getCancellationMessage() {
        String cause = this.mCause.get();
        if (cause != null) {
            if (cause.isEmpty()) {
                return this.mCancellationThrower.apply(cause).getMessage();
            }
            return cause;
        }
        return null;
    }

    @Override
    public String getProcessDescription() {
        return this.mProcessDescription;
    }

    public static Supplier<CancellationPoint> wrap(CancellationPoint theCancellationPoint) {
        return () -> theCancellationPoint;
    }

    @Override
    public void check() {
        if (this.mCause.get() != null) {
            assert (this.mCause.get() != CLOSED_MSG) : "Used closed cancellation point";
            throw this.mCancellationThrower.apply(this.mCause.get());
        }
    }

    @Override
    public boolean isCancelled() {
        return this.mCause.get() != null;
    }

    @Override
    public void cancel() {
        this.cancel(this.mProcessDescription + " has been cancelled");
    }

    @Override
    public void cancel(String theCause) {
        Preconditions.checkNotNull((Object)theCause);
        if (this.mCause.compareAndSet(null, theCause)) {
            LOGGER.info(theCause);
        }
    }

    @Override
    public void wait(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            this.mRootFuture.get(timeout, unit);
        }
        catch (TimeoutException theE) {
            LOGGER.warn("This cancellation point hasn't been closed, please report this stack trace to support:", this.mThrowable);
            throw theE;
        }
    }

    @Override
    public void close() {
        if (!this.mRootFuture.complete(true)) {
            return;
        }
        try {
            this.mCause.set(CLOSED_MSG);
        }
        finally {
            this.mCancellationManager.unregisterCancellationPoint(this, this.mDatabaseName);
        }
    }

    public String toString() {
        return this.mProcessDescription + ". Database: " + this.mDatabaseName;
    }

    public String getDatabaseName() {
        return this.mDatabaseName;
    }
}

