/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.cache;

import com.complexible.common.collect.UpdatablePriorityQueue;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.lang.ref.SoftReference;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentLRUSet<E extends Entry>
extends AbstractSet<E> {
    private final ConcurrentHashMap<E, E> map;
    private final int upperWaterMark;
    private final int lowerWaterMark;
    private final ReentrantLock markAndSweepLock = new ReentrantLock(true);
    private boolean isCleaning = false;
    private volatile boolean islive = true;
    private final Stats stats = new Stats();
    private final int acceptableWaterMark;
    private long oldestEntry = 0L;
    private final EvictionListener<E> evictionListener;
    private ThreadLocal<E> template;
    private SoftReference<Entry[]> cleanupArray = new SoftReference<Object>(null);
    private static Comparator<Entry> COMP = new Comparator<Entry>(){

        @Override
        public int compare(Entry o1, Entry o2) {
            long l2 = o2.lastAccessedCopy;
            long l1 = o1.lastAccessedCopy;
            return l2 < l1 ? -1 : (l2 > l1 ? 1 : 0);
        }
    };

    public static <E extends Entry> ConcurrentLRUSet<E> create(int initCapacity, int maxCapacity, int concurrencyLevel, EvictionListener<E> listener) {
        int upperWatermark = maxCapacity;
        int evictionCount = Math.min(maxCapacity / 10, 2048);
        int lowerWatermark = upperWatermark - evictionCount;
        int acceptableWatermark = (upperWatermark + lowerWatermark) / 2;
        return new ConcurrentLRUSet<E>(upperWatermark, lowerWatermark, acceptableWatermark, initCapacity, concurrencyLevel, listener);
    }

    public ConcurrentLRUSet(int upperWaterMark, int lowerWaterMark, int acceptableWatermark, int initialSize, int concurrencyLevel, EvictionListener<E> evictionListener) {
        if (upperWaterMark < 1) {
            throw new IllegalArgumentException("upperWaterMark must be > 0");
        }
        if (lowerWaterMark >= upperWaterMark) {
            throw new IllegalArgumentException("lowerWaterMark must be  < upperWaterMark");
        }
        this.map = new ConcurrentHashMap(initialSize, 0.75f, concurrencyLevel);
        this.upperWaterMark = upperWaterMark;
        this.lowerWaterMark = lowerWaterMark;
        this.acceptableWaterMark = acceptableWatermark;
        this.evictionListener = evictionListener;
    }

    public void setTemplate(final Supplier<E> supplier) {
        this.template = new ThreadLocal<E>(this){

            @Override
            protected E initialValue() {
                return (Entry)supplier.get();
            }
        };
    }

    public E getTemplate() {
        return (E)((Entry)this.template.get());
    }

    public void setAlive(boolean live) {
        this.islive = live;
    }

    public E get(E key) {
        Entry e = (Entry)this.map.get(key);
        if (e == null) {
            if (this.islive) {
                this.stats.missCounter.incrementAndGet();
            }
            return null;
        }
        if (this.islive) {
            e.lastAccessed = this.stats.accessCounter.incrementAndGet();
        }
        return (E)e;
    }

    @Override
    public boolean remove(Object e) {
        return e instanceof Entry && this.remove((E)((Entry)e)) != null;
    }

    public E remove(E key) {
        Entry cacheEntry = (Entry)this.map.remove(key);
        if (cacheEntry != null) {
            this.stats.size.decrementAndGet();
        }
        return (E)cacheEntry;
    }

    @Override
    public boolean add(E e) {
        return !e.equals(this.put(e));
    }

    public E put(E e) {
        ((Entry)e).lastAccessed = this.stats.accessCounter.incrementAndGet();
        Entry oldCacheEntry = (Entry)this.map.put(e, e);
        int currentSize = oldCacheEntry == null ? this.stats.size.incrementAndGet() : this.stats.size.get();
        if (this.islive) {
            this.stats.putCounter.incrementAndGet();
        } else {
            this.stats.nonLivePutCounter.incrementAndGet();
        }
        if (currentSize > this.upperWaterMark && !this.isCleaning) {
            this.markAndSweep();
        }
        return (E)oldCacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAndSweep() {
        if (!this.markAndSweepLock.tryLock()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            long oldestEntry = this.oldestEntry;
            this.isCleaning = true;
            this.oldestEntry = oldestEntry;
            long timeCurrent = this.stats.accessCounter.get();
            int sz = this.stats.size.get();
            int numRemoved = 0;
            int numKept = 0;
            long newestEntry = timeCurrent;
            long newNewestEntry = -1L;
            long newOldestEntry = Long.MAX_VALUE;
            int wantToKeep = this.lowerWaterMark;
            int wantToRemove = sz - this.lowerWaterMark;
            UpdatablePriorityQueue<Entry> queue = new UpdatablePriorityQueue<Entry>(COMP);
            int myMaxSize = wantToRemove;
            for (Entry ce : this.map.values()) {
                ce.lastAccessedCopy = ce.lastAccessed;
                long thisEntry = ce.lastAccessedCopy;
                if (thisEntry > newestEntry - (long)wantToKeep) {
                    ++numKept;
                    newOldestEntry = Math.min(thisEntry, newOldestEntry);
                    continue;
                }
                if (thisEntry < oldestEntry + (long)wantToRemove) {
                    this.evictEntry(ce);
                    ++numRemoved;
                    continue;
                }
                myMaxSize = sz - this.lowerWaterMark - numRemoved;
                while (queue.size() > myMaxSize && queue.size() > 0) {
                    Entry otherEntry = queue.remove();
                    newOldestEntry = Math.min(otherEntry.lastAccessedCopy, newOldestEntry);
                }
                if (myMaxSize <= 0) break;
                Entry o = ConcurrentLRUSet.myInsertWithOverflow(queue, ce, myMaxSize);
                if (o == null) continue;
                newOldestEntry = Math.min(o.lastAccessedCopy, newOldestEntry);
            }
            for (Entry ce : queue) {
                if (ce == null) continue;
                this.evictEntry(ce);
                ++numRemoved;
            }
            this.oldestEntry = oldestEntry = newOldestEntry == Long.MAX_VALUE ? oldestEntry : newOldestEntry;
        }
        finally {
            this.isCleaning = false;
            this.markAndSweepLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _markAndSweep() {
        if (!this.markAndSweepLock.tryLock()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            long oldestEntry = this.oldestEntry;
            this.isCleaning = true;
            this.oldestEntry = oldestEntry;
            long timeCurrent = this.stats.accessCounter.get();
            int sz = this.stats.size.get();
            int numRemoved = 0;
            int numKept = 0;
            long newestEntry = timeCurrent;
            long newNewestEntry = -1L;
            long newOldestEntry = Long.MAX_VALUE;
            int wantToKeep = this.lowerWaterMark;
            int wantToRemove = sz - this.lowerWaterMark;
            Entry[] eset = this.cleanupArray.get();
            if (eset == null || eset.length < sz && eset.length < this.upperWaterMark) {
                eset = new Entry[Math.min(sz, this.upperWaterMark)];
                this.cleanupArray = new SoftReference<Entry[]>(eset);
            }
            int eSize = 0;
            for (Entry ce : this.map.values()) {
                ce.lastAccessedCopy = ce.lastAccessed;
                long thisEntry = ce.lastAccessedCopy;
                if (thisEntry > newestEntry - (long)wantToKeep) {
                    ++numKept;
                    newOldestEntry = Math.min(thisEntry, newOldestEntry);
                    continue;
                }
                if (thisEntry < oldestEntry + (long)wantToRemove) {
                    this.evictEntry(ce);
                    ++numRemoved;
                    continue;
                }
                if (eSize >= eset.length - 1) continue;
                eset[eSize++] = ce;
                newNewestEntry = Math.max(thisEntry, newNewestEntry);
                newOldestEntry = Math.min(thisEntry, newOldestEntry);
            }
            int numPasses = 1;
            while (sz - numRemoved > this.acceptableWaterMark && --numPasses >= 0) {
                oldestEntry = newOldestEntry == Long.MAX_VALUE ? oldestEntry : newOldestEntry;
                newOldestEntry = Long.MAX_VALUE;
                newestEntry = newNewestEntry;
                newNewestEntry = -1L;
                wantToKeep = this.lowerWaterMark - numKept;
                wantToRemove = sz - this.lowerWaterMark - numRemoved;
                for (int i = eSize - 1; i >= 0; --i) {
                    Entry ce = eset[i];
                    long thisEntry = ce.lastAccessedCopy;
                    if (thisEntry > newestEntry - (long)wantToKeep) {
                        ++numKept;
                        eset[i] = eset[eSize - 1];
                        --eSize;
                        newOldestEntry = Math.min(thisEntry, newOldestEntry);
                        continue;
                    }
                    if (thisEntry < oldestEntry + (long)wantToRemove) {
                        this.evictEntry(ce);
                        ++numRemoved;
                        eset[i] = eset[eSize - 1];
                        --eSize;
                        continue;
                    }
                    newNewestEntry = Math.max(thisEntry, newNewestEntry);
                    newOldestEntry = Math.min(thisEntry, newOldestEntry);
                }
            }
            if (sz - numRemoved > this.acceptableWaterMark) {
                oldestEntry = newOldestEntry == Long.MAX_VALUE ? oldestEntry : newOldestEntry;
                newOldestEntry = Long.MAX_VALUE;
                newestEntry = newNewestEntry;
                newNewestEntry = -1L;
                wantToKeep = this.lowerWaterMark - numKept;
                wantToRemove = sz - this.lowerWaterMark - numRemoved;
                UpdatablePriorityQueue<Entry> queue = new UpdatablePriorityQueue<Entry>(COMP);
                int myMaxSize = wantToRemove;
                for (int i = eSize - 1; i >= 0; --i) {
                    Entry ce = eset[i];
                    long thisEntry = ce.lastAccessedCopy;
                    if (thisEntry > newestEntry - (long)wantToKeep) {
                        ++numKept;
                        newOldestEntry = Math.min(thisEntry, newOldestEntry);
                        continue;
                    }
                    if (thisEntry < oldestEntry + (long)wantToRemove) {
                        this.evictEntry(ce);
                        ++numRemoved;
                        continue;
                    }
                    myMaxSize = sz - this.lowerWaterMark - numRemoved;
                    while (queue.size() > myMaxSize && queue.size() > 0) {
                        Entry otherEntry = queue.remove();
                        newOldestEntry = Math.min(otherEntry.lastAccessedCopy, newOldestEntry);
                    }
                    if (myMaxSize <= 0) break;
                    Entry o = ConcurrentLRUSet.myInsertWithOverflow(queue, ce, myMaxSize);
                    if (o == null) continue;
                    newOldestEntry = Math.min(o.lastAccessedCopy, newOldestEntry);
                }
                for (Entry ce : queue) {
                    if (ce == null) continue;
                    this.evictEntry(ce);
                    ++numRemoved;
                }
            }
            this.oldestEntry = oldestEntry = newOldestEntry == Long.MAX_VALUE ? oldestEntry : newOldestEntry;
        }
        finally {
            this.isCleaning = false;
            this.markAndSweepLock.unlock();
        }
    }

    private static Entry myInsertWithOverflow(UpdatablePriorityQueue<Entry> queue, Entry element, int myMaxSize) {
        if (queue.size() < myMaxSize) {
            queue.add(element);
            return null;
        }
        if (queue.size() > 0 && element.lastAccessedCopy < queue.peek().lastAccessedCopy) {
            return queue.replace(element);
        }
        return element;
    }

    private void evictEntry(E e) {
        Entry o = (Entry)this.map.remove(e);
        if (o == null) {
            return;
        }
        this.stats.size.decrementAndGet();
        this.stats.evictionCounter.incrementAndGet();
        if (this.evictionListener != null) {
            this.evictionListener.evictedEntry(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<E> getOldestAccessedItems(int n) {
        TreeSet<Entry> tree = new TreeSet<Entry>(COMP);
        if (n <= 0) {
            return tree;
        }
        this.markAndSweepLock.lock();
        try {
            for (Entry ce : this.map.keySet()) {
                ce.lastAccessedCopy = ce.lastAccessed;
                if (tree.size() < n) {
                    tree.add(ce);
                    continue;
                }
                if (ce.lastAccessedCopy >= tree.first().lastAccessedCopy) continue;
                tree.remove(tree.first());
                tree.add(ce);
            }
        }
        finally {
            this.markAndSweepLock.unlock();
        }
        return Lists.newArrayList(tree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<E> getLatestAccessedItems(int n) {
        TreeSet<Entry> tree = new TreeSet<Entry>(COMP);
        if (n <= 0) {
            return tree;
        }
        this.markAndSweepLock.lock();
        try {
            for (Entry ce : this.map.keySet()) {
                ce.lastAccessedCopy = ce.lastAccessed;
                if (tree.size() < n) {
                    tree.add(ce);
                    continue;
                }
                if (ce.lastAccessedCopy <= tree.last().lastAccessedCopy) continue;
                tree.remove(tree.last());
                tree.add(ce);
            }
        }
        finally {
            this.markAndSweepLock.unlock();
        }
        return Lists.newArrayList(tree);
    }

    @Override
    public int size() {
        return this.stats.size.get();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Stats getStats() {
        return this.stats;
    }

    @Override
    public Iterator<E> iterator() {
        return ((ConcurrentHashMap.KeySetView)this.map.keySet()).iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.size() > 0;
    }

    public static interface EvictionListener<E extends Entry> {
        public void evictedEntry(E var1);
    }

    public static class Stats {
        private final AtomicLong accessCounter = new AtomicLong(0L);
        private final AtomicLong putCounter = new AtomicLong(0L);
        private final AtomicLong nonLivePutCounter = new AtomicLong(0L);
        private final AtomicLong missCounter = new AtomicLong();
        private final AtomicInteger size = new AtomicInteger();
        private AtomicLong evictionCounter = new AtomicLong();

        public long getCumulativeLookups() {
            return this.accessCounter.get() - this.putCounter.get() - this.nonLivePutCounter.get() + this.missCounter.get();
        }

        public long getCumulativeHits() {
            return this.accessCounter.get() - this.putCounter.get() - this.nonLivePutCounter.get();
        }

        public long getCumulativePuts() {
            return this.putCounter.get();
        }

        public long getCumulativeEvictions() {
            return this.evictionCounter.get();
        }

        public int getCurrentSize() {
            return this.size.get();
        }

        public long getCumulativeNonLivePuts() {
            return this.nonLivePutCounter.get();
        }

        public long getCumulativeMisses() {
            return this.missCounter.get();
        }

        public void add(Stats other) {
            this.accessCounter.addAndGet(other.accessCounter.get());
            this.putCounter.addAndGet(other.putCounter.get());
            this.nonLivePutCounter.addAndGet(other.nonLivePutCounter.get());
            this.missCounter.addAndGet(other.missCounter.get());
            this.evictionCounter.addAndGet(other.evictionCounter.get());
            this.size.set(Math.max(this.size.get(), other.size.get()));
        }
    }

    public static abstract class Entry {
        volatile long lastAccessed = 0L;
        long lastAccessedCopy = 0L;
    }

    public static class LongLongEntry
    extends Entry {
        private long key;
        private long value;

        public LongLongEntry(long key, long value) {
            this.key = key;
            this.value = value;
        }

        public long key() {
            return this.key;
        }

        public long value() {
            return this.value;
        }

        public int hashCode() {
            return (int)(this.key ^ this.key >>> 32);
        }

        public boolean equals(Object obj) {
            if (obj instanceof LongLongEntry) {
                return ((LongLongEntry)obj).key == this.key;
            }
            return false;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }

    public static class LongObjectEntry<V>
    extends Entry {
        private long key;
        private V value;

        public LongObjectEntry(long key, V value) {
            this.key = key;
            this.value = value;
        }

        public long getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public int hashCode() {
            return (int)(this.key ^ this.key >>> 32);
        }

        public boolean equals(Object obj) {
            if (obj instanceof LongObjectEntry) {
                return ((LongObjectEntry)obj).key == this.key;
            }
            return false;
        }

        public LongObjectEntry<V> reset(long key) {
            this.key = key;
            return this;
        }

        public String toString() {
            return this.key + "->" + String.valueOf(this.value);
        }
    }

    public static class ObjectLongEntry<K>
    extends Entry {
        private K key;
        private long value;

        public ObjectLongEntry(K key, long value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public long getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ObjectLongEntry) {
                return ((ObjectLongEntry)obj).key.equals(this.key);
            }
            return false;
        }

        public ObjectLongEntry<K> reset(K key) {
            this.key = key;
            return this;
        }

        public String toString() {
            return String.valueOf(this.key) + "->" + this.value;
        }
    }

    public static class ObjectObjectEntry<K, V>
    extends Entry
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public ObjectObjectEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public ObjectObjectEntry<K, V> reset(K key) {
            this.key = key;
            this.value = null;
            return this;
        }

        public ObjectObjectEntry<K, V> reset(K key, V value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public V setValue(V value) {
            V result = this.value;
            this.value = value;
            return result;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ObjectObjectEntry) {
                return ((ObjectObjectEntry)obj).key.equals(this.key);
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.key) + "->" + String.valueOf(this.value);
        }
    }
}

