/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.cache;

import com.complexible.common.cache.BaseCacheKey;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public abstract class BaseSharedCache<C extends BaseCacheKey, V> {
    protected final int mPartition;
    protected final ConcurrentMap<C, V> cache;

    protected BaseSharedCache(ConcurrentMap<C, V> theCache, int thePartition) {
        this.mPartition = thePartition;
        this.cache = theCache;
    }

    public final long getPartition() {
        return this.mPartition;
    }

    public final ConcurrentMap<C, V> getCache() {
        return this.cache;
    }

    public final boolean contains(C key) {
        return this.cache.containsKey(key);
    }

    public final V get(C key) {
        return this.cache.get(key);
    }

    public final V computeIfAbsent(C key, Function<C, ? extends V> mappingFunction) {
        return this.cache.computeIfAbsent(key, mappingFunction);
    }

    public final V put(C key, V value) {
        return this.cache.put(key, value);
    }

    public final V remove(C key) {
        return this.cache.remove(key);
    }

    public final int size() {
        return this.cache.size();
    }
}

