/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.google.common.base.Strings;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemUtil.class);

    private SystemUtil() {
        throw new AssertionError();
    }

    public static boolean getPropertyAsBoolean(String theProperty, boolean theDefault) {
        String aValue = System.getProperty(theProperty);
        if (aValue == null) {
            return theDefault;
        }
        try {
            return Boolean.parseBoolean(aValue);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Value for property {} is intended to be an boolean, but the provided value {} is not a valid boolean", (Object)theProperty, (Object)theDefault);
            return theDefault;
        }
    }

    public static int getPropertyAsInt(String theProperty, int theDefault) {
        String aValue = System.getProperty(theProperty);
        if (aValue == null) {
            return theDefault;
        }
        try {
            return Integer.parseInt(aValue);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Value for property {} is intended to be an integer, but the provided value {} is not a valid integer", (Object)theProperty, (Object)theDefault);
            return theDefault;
        }
    }

    public static long getPropertyAsLong(String theProperty, long theDefault) {
        String aValue = System.getProperty(theProperty);
        if (aValue == null) {
            return theDefault;
        }
        try {
            return Long.parseLong(aValue);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Value for property {} is intended to be an long, but the provided value {} is not a valid long", (Object)theProperty, (Object)theDefault);
            return theDefault;
        }
    }

    public static double getPropertyAsDouble(String theProperty, double theDefault) {
        return SystemUtil.getPropertyAsNumber(theProperty, Double::parseDouble, theDefault);
    }

    public static <T extends Number> T getPropertyAsNumber(String theProperty, Function<String, T> theParser, T theDefault) {
        String val = System.getProperty(theProperty);
        if (Strings.isNullOrEmpty((String)val)) {
            return theDefault;
        }
        try {
            return (T)((Number)theParser.apply(val));
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid numerical value '{}' for property {}", (Object)val, (Object)theProperty);
            return theDefault;
        }
    }

    public static String getProperty(String theProperty, String theDefault) {
        String aValue = System.getProperty(theProperty);
        if (aValue != null) {
            return aValue;
        }
        return theDefault;
    }
}

