/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.complexible.common.base.SizeFunction;

public final class SizeFunctions {
    public static final int OBJECT_OVERHEAD = 8;
    public static final int REF_OVERHEAD = 8;
    public static final int ARRAY_OVERHEAD = 12;
    public static final SizeFunction<String> STRING = new SizeFunction<String>(){
        private int OVERHEAD = 38;

        @Override
        public int sizeOf(String obj) {
            return 2 * obj.length() + this.OVERHEAD;
        }
    };
    public static final SizeFunction<Number> NUMBER = new SizeFunction<Number>(){

        @Override
        public int sizeOf(Number obj) {
            return (obj instanceof Long ? 8 : 4) + 8;
        }
    };
    public static final SizeFunction<Long> LONG = SizeFunctions.constantSize(16);

    private SizeFunctions() {
        throw new AssertionError();
    }

    public static <T> SizeFunction<T> constantSize(final int size) {
        return new SizeFunction<T>(){

            @Override
            public int sizeOf(T obj) {
                return size;
            }
        };
    }
}

