/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.complexible.common.io.Files2;
import com.complexible.common.util.EnhancedProperties;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;

public final class PropertiesBuilder {
    private final Properties mProperties = new Properties();

    private PropertiesBuilder() {
    }

    public static PropertiesBuilder create() {
        return new PropertiesBuilder();
    }

    public static PropertiesBuilder create(Properties theProps) {
        PropertiesBuilder aBuilder = new PropertiesBuilder();
        aBuilder.mProperties.putAll((Map<?, ?>)theProps);
        return aBuilder;
    }

    public static PropertiesBuilder create(Path theSource) {
        return PropertiesBuilder.create(PropertiesBuilder.propertiesFromFile(theSource));
    }

    public static Properties create(String ... optionPairs) {
        Preconditions.checkArgument((optionPairs.length % 2 == 0 ? 1 : 0) != 0, (Object)"Argument count must be even");
        PropertiesBuilder builder = new PropertiesBuilder();
        for (int i = 0; i < optionPairs.length; i += 2) {
            builder.set(optionPairs[i], optionPairs[i + 1]);
        }
        return builder.build();
    }

    public String get(String theKey) {
        return this.mProperties.getProperty(theKey);
    }

    public PropertiesBuilder set(String theKey, String theValue) {
        this.mProperties.setProperty(theKey, theValue);
        return this;
    }

    public PropertiesBuilder remove(String theKey) {
        this.mProperties.remove(theKey);
        return this;
    }

    public PropertiesBuilder setTrue(String theKey) {
        return this.set(theKey, "true");
    }

    public PropertiesBuilder setFalse(String theKey) {
        return this.set(theKey, "false");
    }

    public PrefixedPropertiesBuilder withPrefix(String thePrefix) {
        return new PrefixedPropertiesBuilder(thePrefix);
    }

    public String toString() {
        return PropertiesBuilder.propertiesToString(this.build());
    }

    public Properties build() {
        Properties aProps = new Properties();
        aProps.putAll((Map<?, ?>)this.mProperties);
        return aProps;
    }

    public static String propertiesToString(Properties properties) {
        return PropertiesBuilder.propertiesToString(properties, true);
    }

    public static String propertiesToString(Properties properties, boolean includeTimestamp) {
        try {
            StringWriter stringWriter = new StringWriter();
            properties.store(stringWriter, null);
            String optionsString = stringWriter.toString();
            if (includeTimestamp) {
                return optionsString;
            }
            return optionsString.substring(optionsString.indexOf(System.lineSeparator()) + System.lineSeparator().length());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Properties propertiesFromString(String theContents) {
        try {
            return new EnhancedProperties(new ByteArrayInputStream(theContents.getBytes(Charsets.UTF_8)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Properties propertiesFromFile(Path theSource) {
        try {
            return PropertiesBuilder.propertiesFromString(Files2.toString(theSource));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public final class PrefixedPropertiesBuilder {
        private final String mPrefix;

        public PrefixedPropertiesBuilder(String thePrefix) {
            this.mPrefix = thePrefix;
        }

        public PrefixedPropertiesBuilder set(String theKey, String theValue) {
            PropertiesBuilder.this.mProperties.setProperty(this.mPrefix + theKey, theValue);
            return this;
        }

        public PrefixedPropertiesBuilder setTrue(String theKey) {
            return this.set(theKey, "true");
        }

        public PrefixedPropertiesBuilder setFalse(String theKey) {
            return this.set(theKey, "false");
        }
    }
}

