/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.complexible.common.base.Numbers;
import com.complexible.common.base.ProgressReporter;
import com.complexible.common.base.ReportIntervalCounter;
import com.complexible.common.timer.DurationFormat;
import com.complexible.common.timer.Timer;
import com.google.common.base.Preconditions;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public abstract class ProgressMonitor
implements ProgressReporter {
    private static final ProgressFormatter DEFAULT_FORMATTER = new DefaultProgressFormatter();
    private static final ProgressMonitor SILENT = new ProgressMonitor(){

        @Override
        public long current() {
            return 0L;
        }

        @Override
        public void increment(long delta) {
        }

        @Override
        public long maxProgress() {
            return 0L;
        }

        @Override
        public void incrementMaxProgress(long theMaxProgress) {
        }

        @Override
        public void print() {
        }

        @Override
        public void stop() {
        }

        @Override
        public String stage() {
            return null;
        }

        @Override
        public void stage(String stageName) {
        }
    };

    @Override
    public abstract void print();

    @Override
    public abstract void stop();

    public static ProgressFormatter tpsFormatter(final long theTripleCount) {
        return new DefaultProgressFormatter(){
            private final String mFormat = " (%1.1fK triples/sec)";

            @Override
            public String format(String theName, int theProgressPercentage, long theElapsedTime) {
                float aSpeed = theElapsedTime == 0L ? 0.0f : (float)(theTripleCount * (long)theProgressPercentage) / (100.0f * (float)theElapsedTime);
                return super.format(theName, theProgressPercentage, theElapsedTime) + String.format(" (%1.1fK triples/sec)", Float.valueOf(aSpeed));
            }
        };
    }

    public static ProgressMonitor silent() {
        return SILENT;
    }

    public static ProgressMonitor create(String name, long maxProgress, PrintStream theOut) {
        return new Builder(name).maxProgress(maxProgress).output(theOut).build();
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static ProgressMonitor minimal(String name, OutputStream output) {
        final PrintStream out = ProgressMonitor.printStream(output);
        out.print(name + "...");
        final Timer timer = new Timer();
        timer.start();
        return new ProgressMonitor(){

            @Override
            public long current() {
                return 0L;
            }

            @Override
            public void increment(long delta) {
            }

            @Override
            public long maxProgress() {
                return 0L;
            }

            @Override
            public void incrementMaxProgress(long theMaxProgress) {
            }

            @Override
            public void print() {
            }

            @Override
            public String stage() {
                return null;
            }

            @Override
            public void stage(String stageName) {
            }

            @Override
            public void stop() {
                out.println("finished in " + timer.format());
            }
        };
    }

    private static PrintStream printStream(OutputStream out) {
        return out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
    }

    public static ProgressMonitor fixedIntervalMonitor(final String taskName, final String elementName, final long interval, final PrintStream out) {
        return new ProgressMonitor(){
            private long progress = 0L;
            private long reportAt = interval;
            private String stage = null;
            private final long time = System.currentTimeMillis();

            @Override
            public void increment(long delta) {
                if ((this.progress += delta) == this.reportAt) {
                    this.reportAt += interval;
                    this.print();
                }
            }

            @Override
            public long maxProgress() {
                return -1L;
            }

            @Override
            public void incrementMaxProgress(long theMaxProgress) {
            }

            @Override
            public long current() {
                return this.progress;
            }

            @Override
            public void print() {
                if (this.progress > interval) {
                    out.printf("%s: %s %s in %s%n", taskName, Numbers.readable(this.progress), elementName, this.elapsedTime());
                }
            }

            @Override
            public void stop() {
                if (this.progress > interval) {
                    out.printf("%s: Finished in %s%n", taskName, this.elapsedTime());
                }
            }

            private String elapsedTime() {
                return DurationFormat.LONG.format(System.currentTimeMillis() - this.time);
            }

            @Override
            public String stage() {
                return this.stage;
            }

            @Override
            public void stage(String stageName) {
                this.stage = stageName;
            }
        };
    }

    public static ProgressMonitor newMultiplyingMonitor(final ProgressMonitor monitor, final int multiplier) {
        return new DelegatingProgressMonitor(monitor){

            @Override
            public void increment(long delta) {
                monitor.increment(delta * (long)multiplier);
            }
        };
    }

    public static ProgressMonitor newBufferedMonitor(final ProgressMonitor monitor, final long limit) {
        return new DelegatingProgressMonitor(monitor){
            private long buffer;
            {
                super(theMonitor);
                this.buffer = 0L;
            }

            @Override
            public void increment(long delta) {
                this.buffer += delta;
                if (this.buffer >= limit) {
                    monitor.increment(this.buffer);
                    this.buffer = 0L;
                }
            }

            @Override
            public long current() {
                return monitor.current() + this.buffer;
            }

            @Override
            public void print() {
                this.flush();
                monitor.print();
            }

            @Override
            public void stop() {
                this.flush();
            }

            private void flush() {
                if (this.buffer > 0L) {
                    monitor.increment(this.buffer);
                    this.buffer = 0L;
                }
            }
        };
    }

    public static class Builder {
        private final String name;
        private ProgressFormatter messageFormatter;
        private long maxProgress = 0L;
        private int reportIntervalPercent = -1;
        private OutputStream output = System.out;
        private ProgressReporter reporterDelegate = null;

        private Builder(String name) {
            this.name = name;
        }

        public ProgressMonitor build() {
            ProgressMonitor m;
            if (this.reportIntervalPercent == -1) {
                this.reportIntervalPercent = this.maxProgress > 1000000L ? 1 : 10;
            }
            ProgressMonitor progressMonitor = m = this.output == null ? ProgressMonitor.silent() : new ThreadSafeMonitor(this);
            if (this.reporterDelegate != null) {
                m = new ReportingProgressMonitor(m, this.reporterDelegate);
                if (this.maxProgress > 0L) {
                    this.reporterDelegate.incrementMaxProgress(this.maxProgress);
                }
            }
            return m;
        }

        public Builder messageFormatter(ProgressFormatter formatter) {
            this.messageFormatter = formatter;
            return this;
        }

        public Builder maxProgress(long maxProgress) {
            this.maxProgress = maxProgress;
            return this;
        }

        public Builder reportIntervalPercent(int reportIntervalPercent) {
            Preconditions.checkArgument((reportIntervalPercent >= 1 && reportIntervalPercent <= 100 ? 1 : 0) != 0, (Object)("Invalid interval: " + reportIntervalPercent));
            this.reportIntervalPercent = reportIntervalPercent;
            return this;
        }

        public Builder output(OutputStream output) {
            this.output = output;
            return this;
        }

        public Builder reportingDelegate(Optional<ProgressReporter> reporter) {
            this.reporterDelegate = reporter.orElse(null);
            return this;
        }
    }

    public static class DefaultProgressFormatter
    implements ProgressFormatter {
        @Override
        public String format(String theName, int theProgressPercentage, long theElapsedTime) {
            return theName + ": " + theProgressPercentage + "% complete in " + this.formatTime(theElapsedTime);
        }

        protected String formatTime(long theElapsedTime) {
            return DurationFormat.MEDIUM.format(theElapsedTime);
        }
    }

    public static interface ProgressFormatter {
        public String format(String var1, int var2, long var3);
    }

    public static class ReportingProgressMonitor
    extends ProgressMonitor {
        private final ProgressMonitor monitor;
        private final ProgressReporter reporter;

        private ReportingProgressMonitor(ProgressMonitor theMonitor, ProgressReporter theReporter) {
            this.monitor = theMonitor;
            this.reporter = theReporter;
        }

        @Override
        public void increment(long delta) {
            this.monitor.increment(delta);
            this.reporter.increment(delta);
        }

        @Override
        public long maxProgress() {
            return this.monitor.maxProgress();
        }

        @Override
        public void incrementMaxProgress(long theMaxProgress) {
            this.monitor.incrementMaxProgress(theMaxProgress);
            this.reporter.incrementMaxProgress(theMaxProgress);
        }

        @Override
        public long current() {
            return this.monitor.current();
        }

        @Override
        public void print() {
            this.monitor.print();
        }

        @Override
        public void stop() {
            this.monitor.stop();
            this.reporter.stop();
        }

        @Override
        public String stage() {
            return this.monitor.stage();
        }

        @Override
        public void stage(String stageName) {
            this.monitor.stage(stageName);
        }
    }

    public static class DelegatingProgressMonitor
    extends ProgressMonitor {
        private final ProgressMonitor monitor;

        private DelegatingProgressMonitor(ProgressMonitor theMonitor) {
            this.monitor = theMonitor;
        }

        @Override
        public void increment(long delta) {
            this.monitor.increment(delta);
        }

        @Override
        public long maxProgress() {
            return this.monitor.maxProgress();
        }

        @Override
        public void incrementMaxProgress(long theMaxProgress) {
            this.monitor.incrementMaxProgress(theMaxProgress);
        }

        @Override
        public long current() {
            return this.monitor.current();
        }

        @Override
        public void print() {
            this.monitor.print();
        }

        @Override
        public void stop() {
            this.monitor.stop();
        }

        @Override
        public String stage() {
            return this.monitor.stage();
        }

        @Override
        public void stage(String stageName) {
            this.monitor.stage(stageName);
        }
    }

    private static class ThreadSafeMonitor
    extends ProgressMonitor {
        private static final long PRINT_THRESHOLD = TimeUnit.SECONDS.toMillis(5L);
        private static final long PRINT_INTERVAL = TimeUnit.SECONDS.toMillis(1L);
        private final String name;
        private final ProgressFormatter message;
        private final PrintStream out;
        private volatile String stage;
        private long maxProgress;
        private long lastPrintTime;
        private final ReportIntervalCounter mReportInterval;

        private ThreadSafeMonitor(Builder builder) {
            this.name = builder.name;
            this.message = builder.messageFormatter == null ? DEFAULT_FORMATTER : builder.messageFormatter;
            this.maxProgress = builder.maxProgress;
            this.out = ProgressMonitor.printStream(builder.output);
            long reportInterval = Math.max(1L, (long)builder.reportIntervalPercent * this.maxProgress / 100L);
            this.mReportInterval = new ReportIntervalCounter(reportInterval);
            this.lastPrintTime = PRINT_THRESHOLD;
        }

        @Override
        public long current() {
            return this.mReportInterval.getCount();
        }

        @Override
        public long maxProgress() {
            return this.maxProgress;
        }

        @Override
        public void increment(long delta) {
            if (this.mReportInterval.increment(delta)) {
                this.print();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void incrementMaxProgress(long theIncrement) {
            ReportIntervalCounter reportIntervalCounter = this.mReportInterval;
            synchronized (reportIntervalCounter) {
                this.maxProgress += theIncrement;
                long reportInterval = Math.max(1L, this.maxProgress / 100L);
                this.mReportInterval.setInterval(reportInterval);
            }
        }

        @Override
        public synchronized void print() {
            long elapsedTime = this.mReportInterval.getElapsedTime();
            if (elapsedTime - this.lastPrintTime < PRINT_INTERVAL) {
                return;
            }
            this.printInternal(elapsedTime);
        }

        private void printInternal(long elapsedTime) {
            this.lastPrintTime = elapsedTime;
            int currentProgressPercent = this.maxProgress == 0L ? 100 : Math.min(100, (int)(100L * this.mReportInterval.getCount() / this.maxProgress));
            String msg = this.message.format(this.name, currentProgressPercent, elapsedTime);
            this.out.println(msg);
        }

        @Override
        public void stop() {
            this.mReportInterval.increment(this.maxProgress - this.mReportInterval.getCount());
            long elapsedTime = this.mReportInterval.getElapsedTime();
            if (elapsedTime > PRINT_THRESHOLD) {
                this.printInternal(this.mReportInterval.getElapsedTime());
                this.out.println();
                this.out.println(this.name + " finished in " + DurationFormat.LONG.format(elapsedTime));
                this.out.flush();
            }
        }

        @Override
        public String stage() {
            return this.stage;
        }

        @Override
        public void stage(String stageName) {
            this.stage = stageName;
        }
    }
}

