/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.complexible.common.base.Functional;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Pair<K1, K2> {
    private static final int UNINITIALIZED_HASH_CODE = -1596111516;
    public final K1 first;
    public final K2 second;
    private volatile int hashCode = -1596111516;

    private Pair(K1 a, K2 b) {
        this.first = a;
        this.second = b;
    }

    public static <S, T> Pair<S, T> create(S a, T b) {
        return new Pair<S, T>(a, b);
    }

    public static <S, T> Pair<S, T> createFromFirst(S a, Function<S, T> aToB) {
        return new Pair<S, T>(a, aToB.apply(a));
    }

    public K1 first() {
        return this.first;
    }

    public K2 second() {
        return this.second;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Pair) {
            Pair other = (Pair)o;
            return this.hashCode() == other.hashCode() && Objects.equal(this.first, other.first) && Objects.equal(this.second, other.second);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == -1596111516) {
            this.hashCode = (this.first == null ? 37 : this.first.hashCode()) ^ (this.second == null ? 7 : this.second.hashCode());
        }
        return this.hashCode;
    }

    public String toString() {
        return "(" + String.valueOf(this.first) + ", " + String.valueOf(this.second) + ")";
    }

    public static <K1 extends Comparable<K1>, K2 extends Comparable<K2>> Comparator<Pair<K1, K2>> comparator() {
        return Comparator.comparing(Pair::first).thenComparing(Pair::second);
    }

    public static <K1, K2> Collector<Pair<K1, K2>, ?, Map<K1, K2>> toMap() {
        return Collectors.toMap(Pair::first, Pair::second);
    }

    public static <K1, K2> Collector<Pair<K1, K2>, ?, Map<K1, K2>> toMap(Supplier<Map<K1, K2>> mapSupplier) {
        return Collectors.toMap(Pair::first, Pair::second, Functional.throwingCombiner(), mapSupplier);
    }

    public static <E> Stream<E> toStream(Pair<E, E> pair) {
        return Stream.of(pair.first, pair.second);
    }

    public static <K1_I, K1_O, K2> Function<Pair<K1_I, K2>, Pair<K1_O, K2>> liftOverFirst(Function<K1_I, K1_O> mapper) {
        return Pair.pairBiFunction((first, second) -> Pair.create(mapper.apply(first), second));
    }

    public static <K1, K2_I, K2_O> Function<Pair<K1, K2_I>, Pair<K1, K2_O>> liftOverSecond(Function<? super K2_I, ? extends K2_O> mapper) {
        return Pair.pairBiFunction((first, second) -> Pair.create(first, mapper.apply((Object)second)));
    }

    public static <P1, P2, R> Function<Pair<P1, P2>, R> pairBiFunction(BiFunction<P1, P2, R> mapper) {
        return p -> mapper.apply(p.first, p.second);
    }

    public static <P1, P2> Predicate<Pair<P1, P2>> pairBiPredicate(BiPredicate<P1, P2> mapper) {
        return p -> mapper.test(p.first, p.second);
    }

    public static <P1, P2> Consumer<Pair<P1, P2>> pairBiConsumer(BiConsumer<P1, P2> mapper) {
        return p -> mapper.accept(p.first, p.second);
    }

    public static <K, V> Function<Map.Entry<K, V>, Pair<K, V>> fromMapEntry() {
        return Pair::fromMapEntry;
    }

    public static <K, V> Pair<K, V> fromMapEntry(Map.Entry<K, V> e) {
        return Pair.create(e.getKey(), e.getValue());
    }

    public static <K, V> Stream<Pair<K, V>> streamMap(Map<K, V> m) {
        return Optional.ofNullable(m).orElse(Collections.emptyMap()).entrySet().stream().map(Pair.fromMapEntry());
    }
}

