/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.complexible.common.base.Memory;
import com.google.common.io.CharStreams;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OSUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSUtil.class);
    public static final NativeMemoryUsage ERROR = new NativeMemoryUsage(0L, 0L);
    private static long pid = Long.MIN_VALUE;

    private OSUtil() {
        throw new AssertionError();
    }

    public static NativeMemoryUsage getNativeMemory() {
        try {
            String[] strs = OSUtil.getNativeMemoryInfo().replaceAll("\\s+", " ").split(" ");
            return new NativeMemoryUsage(Long.parseLong(strs[4]) * 1024L, Long.parseLong(strs[5]) * 1024L);
        }
        catch (Exception e) {
            LOGGER.debug("Error getting native memory info", (Throwable)e);
            return ERROR;
        }
    }

    public static String getNativeMemoryInfo() {
        try {
            long pid = OSUtil.getPID();
            String[] cmd = new String[]{"ps", "-p", String.valueOf(pid), "-o", "pid,vsz,rss"};
            Process p = Runtime.getRuntime().exec(cmd);
            StringBuilder sb = new StringBuilder();
            CharStreams.copy((Readable)new InputStreamReader(p.getInputStream()), (Appendable)sb);
            return sb.toString().trim();
        }
        catch (Exception e) {
            LOGGER.debug("Error getting naitve memory info", (Throwable)e);
            return "N/A";
        }
    }

    public static long getPID() {
        if (pid == Long.MIN_VALUE) {
            try {
                String[] cmd = new String[]{"bash", "-c", "echo $PPID"};
                Process p = Runtime.getRuntime().exec(cmd);
                StringBuilder sb = new StringBuilder();
                CharStreams.copy((Readable)new InputStreamReader(p.getInputStream()), (Appendable)sb);
                pid = Long.parseLong(sb.toString().trim());
            }
            catch (Exception e) {
                LOGGER.debug("Error getting PID", (Throwable)e);
                pid = -1L;
            }
        }
        return pid;
    }

    public static class NativeMemoryUsage {
        public final long mVirtualMem;
        public final long mResidentMem;

        public NativeMemoryUsage(long mVirtualMem, long mResidentMem) {
            this.mVirtualMem = mVirtualMem;
            this.mResidentMem = mResidentMem;
        }

        public String toString() {
            return String.format("Virtual Mem: %s Resident Mem: %s", Memory.readable(this.mVirtualMem), Memory.readable(this.mResidentMem));
        }
    }
}

