/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.google.common.math.DoubleMath;
import java.util.Locale;

public final class Numbers {
    public static final long THOUSAND = 1000L;
    public static final long K = 1000L;
    public static final long MILLION = 1000000L;
    public static final long M = 1000000L;
    public static final long BILLION = 1000000000L;

    private Numbers() {
    }

    public static String readable(long number) {
        return Numbers.readable(Locale.US, number);
    }

    public static String readable(Locale l, long number) {
        if (number < 1000L) {
            return String.valueOf(number);
        }
        if (number < 10000L) {
            return String.format(l, "%1.1fK", (double)number / 1000.0);
        }
        if (number < 1000000L) {
            return String.format(l, "%1.0fK", (double)number / 1000.0);
        }
        return String.format(l, "%1.1fM", (double)number / 1000000.0);
    }

    public static Number fromReadable(String theStr) {
        if (theStr == null || theStr.isEmpty()) {
            throw new IllegalArgumentException("Empty string");
        }
        char aSuffix = theStr.charAt(theStr.length() - 1);
        int aEndIndex = theStr.length() - 1;
        if (Character.isDigit(aSuffix)) {
            ++aEndIndex;
            aSuffix = ' ';
        }
        double aBase = Double.parseDouble(theStr.substring(0, aEndIndex));
        switch (aSuffix) {
            case ' ': {
                return Numbers.valueOf(aBase);
            }
            case 'K': 
            case 'k': {
                return Numbers.valueOf(aBase * 1000.0);
            }
            case 'M': 
            case 'm': {
                return Numbers.valueOf(aBase * 1000000.0);
            }
        }
        throw new IllegalArgumentException("Unknown suffix: " + aSuffix);
    }

    public static String readable(double number) {
        return Numbers.readable(Locale.US, number);
    }

    public static String readable(Locale l, double number) {
        return String.format(l, "%1.3f", number);
    }

    public static Number valueOf(long value) {
        return value < Integer.MAX_VALUE ? (Number)((int)value) : (Number)value;
    }

    public static Number valueOf(double value) {
        return DoubleMath.isMathematicalInteger((double)value) ? (Number)Numbers.valueOf((long)value) : (Number)value;
    }

    public static boolean isNaN(Number value) {
        return value instanceof Double && ((Double)value).isNaN() || value instanceof Float && ((Float)value).isNaN();
    }

    public static String formatIfIntegral(Object number) {
        if (number instanceof Long || number instanceof Integer || number instanceof Short) {
            return String.format("%,d", number);
        }
        return number.toString();
    }

    public static String formatWithSeparator(long number) {
        return String.format("%,d", number);
    }
}

