/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.complexible.common.base.Sorter;
import com.complexible.common.primitives.ArrayUtil;
import java.util.Comparator;

class MergeSorter<T>
extends Sorter<T> {
    private final T[] out;

    public MergeSorter(int length, Comparator<? super T> comp) {
        super(comp);
        this.out = ArrayUtil.newArray(length);
    }

    @Override
    public void sort(T[] array, int start, int end) {
        MergeSorter.checkBounds(array.length, start, end);
        if (end - start > this.out.length) {
            throw new IllegalArgumentException("Sort range is greater than the sorter capcacity: " + (end - start) + " > " + this.out.length);
        }
        int length = end - start;
        if (length <= 0) {
            return;
        }
        System.arraycopy(array, start, this.out, start, length);
        this.mergeSort(this.out, array, start, end);
    }

    private void mergeSort(T[] in, T[] out, int start, int end) {
        Comparator c = this.c;
        int len = end - start;
        if (len <= 7) {
            for (int i = start + 1; i < end; ++i) {
                T prev = out[i - 1];
                T current = out[i];
                if (c.compare(prev, current) <= 0) continue;
                int j = i;
                do {
                    out[j--] = prev;
                } while (j > start && c.compare(prev = out[j - 1], current) > 0);
                out[j] = current;
            }
            return;
        }
        int med = end + start >>> 1;
        this.mergeSort(out, in, start, med);
        this.mergeSort(out, in, med, end);
        if (c.compare(in[med - 1], in[med]) <= 0) {
            System.arraycopy(in, start, out, start, len);
            return;
        }
        int r = med;
        int i = start;
        do {
            int toCopy;
            T rVal;
            T fromVal;
            if (c.compare(fromVal = in[start], rVal = in[r]) <= 0) {
                int l_1 = this.find(in, rVal, -1, start + 1, med - 1);
                toCopy = l_1 - start + 1;
                System.arraycopy(in, start, out, i, toCopy);
                i += toCopy;
                out[i++] = rVal;
                ++r;
                start = l_1 + 1;
                continue;
            }
            int r_1 = this.find(in, fromVal, 0, r + 1, end - 1);
            toCopy = r_1 - r + 1;
            System.arraycopy(in, r, out, i, toCopy);
            i += toCopy;
            out[i++] = fromVal;
            ++start;
            r = r_1 + 1;
        } while (end - r > 0 && med - start > 0);
        if (end - r <= 0) {
            System.arraycopy(in, start, out, i, med - start);
        } else {
            System.arraycopy(in, r, out, i, end - r);
        }
    }

    private int find(T[] arr, T val, int bnd, int l, int r) {
        Comparator c = this.c;
        int m = l;
        int d = 1;
        while (m <= r) {
            if (c.compare(val, arr[m]) <= bnd) {
                r = m - 1;
                break;
            }
            l = m + 1;
            m += d;
            d <<= 1;
        }
        while (l <= r) {
            m = l + r >>> 1;
            if (c.compare(val, arr[m]) > bnd) {
                l = m + 1;
                continue;
            }
            r = m - 1;
        }
        return l - 1;
    }

    private static void checkBounds(int arrLength, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("Start index " + start + " is greater than end index " + end);
        }
        if (start < 0) {
            throw new ArrayIndexOutOfBoundsException("Array index out of range " + start);
        }
        if (end > arrLength) {
            throw new ArrayIndexOutOfBoundsException("Array index out of range " + end);
        }
    }
}

