/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.complexible.common.base.Instrumentor;
import com.google.common.collect.Sets;
import com.sun.management.OperatingSystemMXBean;
import java.lang.instrument.Instrumentation;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Memory {
    private static final Logger LOGGER = LoggerFactory.getLogger(Memory.class);
    private static final MemoryMXBean MEMORY = ManagementFactory.getMemoryMXBean();
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static final DecimalFormat ONE_FRACTION_DIGIT = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.US));
    private static final DecimalFormat NO_FRACTION_DIGIT = new DecimalFormat("0", new DecimalFormatSymbols(Locale.US));
    private static final String BYTE_COUNT_SUFFIX = "BKMGT";
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final int DEFAULT_PAGE_SIZE = 4096;

    private Memory() {
        throw new AssertionError();
    }

    public static String readable(long bytes) {
        int i;
        double result = bytes;
        for (i = 0; result >= 1000.0 && i < BYTE_COUNT_SUFFIX.length() - 1; result /= 1024.0, ++i) {
        }
        DecimalFormat formatter = result < 10.0 && i > 0 ? ONE_FRACTION_DIGIT : NO_FRACTION_DIGIT;
        return formatter.format(result) + BYTE_COUNT_SUFFIX.charAt(i);
    }

    public static long fromReadable(String theStr) {
        if (theStr == null || theStr.isEmpty()) {
            throw new IllegalArgumentException("Empty string");
        }
        int aEndIndex = theStr.length() - 1;
        int aSuffix = Character.toUpperCase(theStr.charAt(aEndIndex));
        if (Character.isDigit((char)aSuffix)) {
            ++aEndIndex;
            aSuffix = 66;
        }
        double aBytes = Double.parseDouble(theStr.substring(0, aEndIndex));
        switch (aSuffix) {
            case 66: {
                return (long)aBytes;
            }
            case 75: {
                return (long)(aBytes * 1024.0);
            }
            case 77: {
                return (long)(aBytes * 1048576.0);
            }
            case 71: {
                return (long)(aBytes * 1.073741824E9);
            }
            case 84: {
                return (long)(aBytes * 1.099511627776E12);
            }
        }
        throw new IllegalArgumentException("Invalid memory value: " + theStr);
    }

    public static long used() {
        return RUNTIME.totalMemory() - RUNTIME.freeMemory();
    }

    public static long total() {
        return RUNTIME.totalMemory();
    }

    public static long max() {
        return RUNTIME.maxMemory();
    }

    public static long available() {
        return Memory.max() - Memory.used();
    }

    public static long system() {
        return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize();
    }

    public static float usedRatio() {
        return 1.0f - (float)RUNTIME.freeMemory() / (float)RUNTIME.totalMemory();
    }

    public static long usedHeap() {
        return MEMORY.getHeapMemoryUsage().getUsed();
    }

    public static long usedNonHeap() {
        return MEMORY.getNonHeapMemoryUsage().getUsed();
    }

    public static String heapUsage() {
        MemoryUsage usage = MEMORY.getHeapMemoryUsage();
        StringBuilder sb = new StringBuilder();
        sb.append("init = ").append(Memory.readable(usage.getInit()));
        sb.append(" used = ").append(Memory.readable(usage.getUsed()));
        sb.append(" committed = ").append(Memory.readable(usage.getCommitted()));
        sb.append(" max = ").append(Memory.readable(usage.getMax()));
        return sb.toString();
    }

    public static String detailedUsage() {
        StringBuilder sb = new StringBuilder();
        try {
            Formatter formatter = new Formatter(sb);
            formatter.format("%nDETAILED MEMORY INFO%n", new Object[0]);
            formatter.format("Heap Memory Usage: %s%n", MEMORY.getHeapMemoryUsage());
            formatter.format("Non-Heap Memory Usage: %s%n", MEMORY.getNonHeapMemoryUsage());
            List<GarbageCollectorMXBean> gcmBeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean gcmBean : gcmBeans) {
                formatter.format("Name: %s%n", gcmBean.getName());
                formatter.format("\tCollection count: %s%n", gcmBean.getCollectionCount());
                formatter.format("\tCollection time: %s%n", gcmBean.getCollectionTime());
                formatter.format("\tMemory Pools: %s%n", Arrays.toString(gcmBean.getMemoryPoolNames()));
            }
            formatter.format("%nMemory Pools Info%n", new Object[0]);
            List<MemoryPoolMXBean> mpBeans = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean mpBean : mpBeans) {
                formatter.format("Name: %s%n", mpBean.getName());
                formatter.format("\tUsage: %s%n", mpBean.getUsage());
                formatter.format("\tCollection Usage: %s%n", mpBean.getCollectionUsage());
                formatter.format("\tPeak Usage: %s%n", mpBean.getPeakUsage());
                formatter.format("\tType: %s%n", new Object[]{mpBean.getType()});
                formatter.format("\tMemory Manager Names: %s%n", Arrays.toString(mpBean.getMemoryManagerNames()));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot get memory info", (Throwable)e);
        }
        return sb.toString();
    }

    public static long sizeOf(Object obj) {
        return Memory.sizeOf(obj, Sets.newIdentityHashSet());
    }

    private static long sizeOf(Object obj, Set<Object> visited) {
        Instrumentation instrumentation = Instrumentor.instrumentation();
        if (instrumentation == null) {
            return -1L;
        }
        if (obj == null) {
            return 0L;
        }
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        visited.add(obj);
        queue.add(obj);
        int result = 0;
        while (!queue.isEmpty()) {
            obj = queue.removeFirst();
            result = (int)((long)result + instrumentation.getObjectSize(obj));
            Class<?> objClass = obj.getClass();
            if (objClass.isArray() && !objClass.getComponentType().isPrimitive()) {
                int arrayLength = Array.getLength(obj);
                for (int i = 0; i < arrayLength; ++i) {
                    Object ref = Array.get(obj, i);
                    if (ref == null || !visited.add(ref)) continue;
                    queue.addFirst(ref);
                }
            }
            while (objClass != null) {
                for (Field fld : objClass.getDeclaredFields()) {
                    Class<?> fieldClass;
                    int mod = fld.getModifiers();
                    if ((mod & 8) != 0 || (fieldClass = fld.getType()).isPrimitive()) continue;
                    if (!fld.isAccessible()) {
                        fld.setAccessible(true);
                    }
                    try {
                        Object ref = fld.get(obj);
                        if (ref == null || !visited.add(ref)) continue;
                        queue.addFirst(ref);
                    }
                    catch (IllegalAccessException illAcc) {
                        throw new InternalError("Couldn't read " + String.valueOf(fld));
                    }
                }
                objClass = objClass.getSuperclass();
            }
        }
        return result;
    }
}

