/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class Maths {
    private Maths() {
        throw new AssertionError();
    }

    public static double log10(BigInteger theValue) {
        int length = theValue.toString().length();
        BigDecimal div = BigDecimal.TEN.pow(length);
        BigDecimal res = new BigDecimal(theValue).divide(div);
        return Math.log10(res.doubleValue()) + (double)length;
    }

    public static int roundUp(int x, int quant) {
        Preconditions.checkArgument((x > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((quant > 0 ? 1 : 0) != 0);
        int result = (x + quant - 1) / quant * quant;
        if (result < 0) {
            throw new ArithmeticException("Overflow rounding " + x + " to the next multiple of " + quant);
        }
        return result;
    }

    public static long roundUp(long x, int quant) {
        Preconditions.checkArgument((x > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((quant > 0 ? 1 : 0) != 0);
        long result = (x + (long)quant - 1L) / (long)quant * (long)quant;
        if (result < 0L) {
            throw new ArithmeticException("Overflow rounding " + x + " to the next multiple of " + quant);
        }
        return result;
    }
}

