/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class Functional {
    public static <K, V, R> Function<Map.Entry<K, V>, R> mapEntryBiFunction(BiFunction<K, V, R> mapper) {
        return entry -> mapper.apply(entry.getKey(), entry.getValue());
    }

    public static <K, V> Consumer<Map.Entry<K, V>> mapEntryBiConsumer(BiConsumer<K, V> consumer) {
        return entry -> consumer.accept(entry.getKey(), entry.getValue());
    }

    public static <T> UnaryOperator<T> wrapPartialWithIdentity(UnaryOperator<T> partialFunction) {
        return o -> MoreObjects.firstNonNull(partialFunction.apply(o), (Object)o);
    }

    public static <T, R> Function<T, R> wrapPartial(Function<T, R> partialFunction, Function<T, R> ifNullFunction) {
        return input -> {
            Object output = partialFunction.apply(input);
            return output == null ? ifNullFunction.apply(input) : output;
        };
    }

    public static <A, B, C> Function<A, C> compose(Function<? super B, C> g, Function<? super A, ? extends B> f) {
        return g.compose(f);
    }

    public static <T> Predicate<T> negate(Predicate<T> p) {
        return p.negate();
    }

    public static BooleanSupplier negate(BooleanSupplier p) {
        return () -> !p.getAsBoolean();
    }

    public static <T> BinaryOperator<T> throwingCombiner() {
        return (x, y) -> {
            throw new UnsupportedOperationException();
        };
    }
}

