/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class AutoCloser
implements AutoCloseable {
    private final Deque<AutoCloseable> stack = new ArrayDeque<AutoCloseable>(4);
    private Throwable thrown;

    public static <E extends Exception> void close(Iterable<? extends AutoCloseable> theCloseables) throws E {
        if (theCloseables == null) {
            return;
        }
        AutoCloser.close((AutoCloseable[])Iterables.toArray(theCloseables, AutoCloseable.class));
    }

    public static void close(AutoCloseable ... theCloseables) {
        AutoCloser.close((T err) -> {
            Throwables.throwIfInstanceOf((Throwable)err, RuntimeException.class);
            throw new RuntimeException((Throwable)err);
        }, theCloseables);
    }

    public static <T extends Throwable> void close(Consumer<T> errConsumer, Iterable<? extends AutoCloseable> theCloseables) {
        Throwable aEx = null;
        for (AutoCloseable autoCloseable : theCloseables) {
            try {
                if (autoCloseable == null) continue;
                autoCloseable.close();
            }
            catch (Throwable t) {
                if (aEx == null) {
                    aEx = t;
                    continue;
                }
                aEx.addSuppressed(t);
            }
        }
        if (aEx != null) {
            errConsumer.accept(aEx);
        }
    }

    public static <T extends Throwable> void close(Consumer<T> errConsumer, AutoCloseable ... theCloseables) {
        AutoCloser.close(errConsumer, Arrays.asList(theCloseables));
    }

    public static void closeSuppressedBy(Exception theE, AutoCloseable ... theCloseables) {
        for (AutoCloseable aToClose : theCloseables) {
            try {
                if (aToClose == null) continue;
                aToClose.close();
            }
            catch (Throwable t) {
                theE.addSuppressed(t);
            }
        }
    }

    public static AutoCloser create() {
        return new AutoCloser();
    }

    private AutoCloser() {
    }

    public <C extends AutoCloseable> C register(@Nullable C closeable) {
        if (closeable != null) {
            this.stack.addFirst(closeable);
        }
        return closeable;
    }

    public RuntimeException rethrow(Throwable e) throws Exception {
        Preconditions.checkNotNull((Object)e, (Object)"exception must be non null to rethrow");
        this.thrown = e;
        Throwables.throwIfInstanceOf((Throwable)e, Exception.class);
        throw new AssertionError((Object)e);
    }

    @Override
    public void close() {
        Throwable throwable = this.thrown;
        while (!this.stack.isEmpty()) {
            AutoCloseable closeable = this.stack.removeFirst();
            try {
                closeable.close();
            }
            catch (Throwable e) {
                if (throwable == null) {
                    throwable = e;
                    continue;
                }
                this.suppress(throwable, e);
            }
        }
        if (this.thrown == null && throwable != null) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new AssertionError((Object)throwable);
        }
    }

    private void suppress(Throwable thrown, Throwable suppressed) {
        if (thrown != suppressed) {
            thrown.addSuppressed(suppressed);
        }
    }

    public static <O, I extends AutoCloseable, E extends Exception> O applyAndCloseOnError(I theClosable, Function<I, O> theAction, Function<Throwable, E> theErrMapper) throws E {
        try {
            return theAction.apply(theClosable);
        }
        catch (Throwable e) {
            AutoCloser.close(theClosable);
            throw (Exception)theErrMapper.apply(e);
        }
    }
}

