/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.language;

import com.stardog.stark.Literal;
import com.stardog.stark.Values;
import com.stardog.stark.io.InvalidLiteral;
import com.stardog.stark.io.LanguageHandler;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public final class RFC3066LanguageHandler
implements LanguageHandler {
    private static final Pattern matcher = Pattern.compile("[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");

    @Override
    public boolean isRecognizedLanguage(@Nonnull String theLang) {
        return matcher.matcher(theLang).matches();
    }

    @Override
    public boolean verifyLanguage(@Nonnull String theValue, @Nonnull String theLang) throws InvalidLiteral {
        Objects.requireNonNull(theLang, "Language tag cannot be null");
        Objects.requireNonNull(theValue, "Literal value cannot be null");
        if (this.isRecognizedLanguage(theLang)) {
            return true;
        }
        throw new InvalidLiteral("Could not verify RFC3066 language tag: " + theLang);
    }

    @Override
    @Nonnull
    public Literal normalizeLanguage(@Nonnull String theValue, @Nonnull String theLang) throws InvalidLiteral {
        Objects.requireNonNull(theLang, "Language tag cannot be null");
        Objects.requireNonNull(theValue, "Literal value cannot be null");
        if (this.isRecognizedLanguage(theLang)) {
            return Values.literal((String)theValue, (String)this.normalizeLanguageTag(theLang));
        }
        throw new InvalidLiteral("Could not normalize RFC3066 language tag: " + theLang);
    }

    @Override
    @Nonnull
    public String normalizeLanguageTag(@Nonnull String theLang) {
        return theLang.toLowerCase().intern();
    }

    @Override
    @Nonnull
    public String key() {
        return "com.stardog.stark.io.languages.RFC3066";
    }
}

