/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.datatypes;

import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Values;
import com.stardog.stark.XMLDatatypes;
import com.stardog.stark.io.DatatypeHandler;
import com.stardog.stark.io.InvalidLiteral;
import javax.annotation.Nonnull;

public final class XMLSchemaDatatypeHandler
implements DatatypeHandler {
    private static final String XMLSCHEMA = "stark.datatypes.xmlschema";

    @Override
    public boolean isRecognizedDatatype(@Nonnull IRI datatypeUri) {
        Datatype dt = Datatype.of((IRI)datatypeUri);
        return dt != Datatype.UDF && dt != Datatype.LANG_STRING;
    }

    @Override
    public boolean verifyDatatype(@Nonnull String theValue, @Nonnull Datatype theDatatype) {
        return XMLDatatypes.isValidValue((String)theValue, (Datatype)theDatatype);
    }

    @Override
    @Nonnull
    public Literal normalizeDatatype(@Nonnull String theValue, @Nonnull Datatype theDatatype) throws InvalidLiteral {
        try {
            return Values.literal((String)XMLDatatypes.normalize((String)theValue, (Datatype)theDatatype), (Datatype)theDatatype);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLiteral("Could not normalise XMLSchema literal", e);
        }
    }

    @Override
    public String key() {
        return XMLSCHEMA;
    }
}

