/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io;

import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.common.collect.ArrayIterator;
import com.complexible.common.util.AlphaNumericComparator;
import com.complexible.common.util.ServiceLoaders;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Statement;
import com.stardog.stark.impl.ImmutableNamespaces;
import com.stardog.stark.io.CompressedRDFFormat;
import com.stardog.stark.io.ForwardingRDFWriter;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriterFactory;
import com.stardog.stark.io.WriterOptions;
import com.stardog.stark.io.WritingFailed;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.zip.DeflaterOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class RDFWriters {
    private static final Map<RDFFormat, RDFWriterFactory> WRITERS = new HashMap<RDFFormat, RDFWriterFactory>();

    public static Optional<RDFWriter> to(@Nonnull OutputStream theOutput, @Nonnull RDFFormat theFormat) {
        return RDFWriters.to(theOutput, theFormat, WriterOptions.defaults());
    }

    public static Optional<RDFWriter> to(@Nonnull OutputStream theOutput, @Nonnull RDFFormat theFormat, @Nonnull Iterable<Namespace> theNamespaces) {
        return RDFWriters.to(theOutput, theFormat, WriterOptions.namespaces(theNamespaces));
    }

    public static Optional<RDFWriter> to(@Nonnull OutputStream theOutput, @Nonnull RDFFormat theFormat, @Nonnull Options theWriterOptions) {
        RDFFormat aFormat;
        OutputStream aOutputStream;
        if (theFormat instanceof CompressedRDFFormat) {
            try {
                aOutputStream = ((CompressedRDFFormat)theFormat).compression().compress(theOutput);
                aFormat = ((CompressedRDFFormat)theFormat).baseFormat();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot compress output", e);
            }
        } else {
            aOutputStream = theOutput;
            aFormat = theFormat;
        }
        return WRITERS.values().stream().filter(theParser -> theParser.format().equals(aFormat)).map(theFactory -> theFactory.create(aOutputStream, theWriterOptions)).findFirst().map(w -> {
            if (aOutputStream instanceof DeflaterOutputStream) {
                return new ForwardingRDFWriter((RDFWriter)w){

                    @Override
                    public void end() {
                        super.end();
                        try {
                            ((DeflaterOutputStream)aOutputStream).finish();
                        }
                        catch (IOException e) {
                            throw new WritingFailed(e);
                        }
                    }
                };
            }
            return w;
        });
    }

    public static long write(@Nonnull RDFWriter theWriter, @Nonnull Iterable<Statement> theStmts) {
        return RDFWriters.write(theWriter, theStmts, (Iterable<Namespace>)ImmutableNamespaces.empty());
    }

    public static long write(@Nonnull RDFWriter theWriter, @Nonnull Iterable<Statement> theStmts, @Nonnull Iterable<Namespace> theNamespaces) {
        theWriter.start();
        theNamespaces.forEach(ns -> theWriter.namespace(ns.prefix(), ns.iri()));
        long aCount = 0L;
        for (Statement aStmt : theStmts) {
            theWriter.handle(aStmt);
            ++aCount;
        }
        theWriter.end();
        return aCount;
    }

    public static long write(@Nonnull OutputStream theStream, @Nonnull RDFFormat theFormat, @Nonnull Iterable<Statement> theStmts) {
        return RDFWriters.write(theStream, theFormat, theStmts, (Iterable<Namespace>)Namespaces.DEFAULT);
    }

    public static long write(@Nonnull OutputStream theStream, @Nonnull RDFFormat theFormat, @Nonnull Iterable<Statement> theStmts, @Nonnull Iterable<Namespace> theNamespaces) {
        return RDFWriters.write(RDFWriters.to(theStream, theFormat).orElseThrow(() -> new IllegalArgumentException("Unsupported RDF format provided")), theStmts, theNamespaces);
    }

    public static long writeGrouped(@Nonnull OutputStream theStream, @Nonnull RDFFormat theFormat, @Nonnull Iterable<Statement> theStmts, @Nonnull Iterable<Namespace> theNamespaces) {
        Statement[] aSortedStmts = (Statement[])Iterables.toArray(theStmts, Statement.class);
        Arrays.sort(aSortedStmts, AlphaNumericComparator.caseSensitive());
        return RDFWriters.write(RDFWriters.to(theStream, theFormat).orElseThrow(() -> new IllegalArgumentException("Unsupported RDF format provided")), () -> new ArrayIterator((Object[])aSortedStmts), theNamespaces);
    }

    public static long writeGrouped(@Nonnull RDFWriter theWriter, @Nonnull Iterable<Statement> theStmts, @Nonnull Iterable<Namespace> theNamespaces) {
        Statement[] aSortedStmts = (Statement[])Iterables.toArray(theStmts, Statement.class);
        Arrays.sort(aSortedStmts, AlphaNumericComparator.caseSensitive());
        return RDFWriters.write(theWriter, () -> new ArrayIterator((Object[])aSortedStmts), theNamespaces);
    }

    @Nonnull
    public static String toString(@Nonnull Iterable<Statement> theStatements, @Nonnull RDFFormat theFormat) {
        return RDFWriters.toString(theStatements, theFormat, (Iterable<Namespace>)Namespaces.DEFAULT);
    }

    @Nonnull
    public static String toString(@Nonnull Iterable<Statement> theStatements, @Nonnull RDFFormat theFormat, @Nonnull Iterable<Namespace> theNamespaces) {
        Preconditions.checkArgument((!theFormat.equals(RDFFormats.BINARY) ? 1 : 0) != 0, (Object)"BINARY format not supported in String format. Use com.stardog.stark.io.RDFWriters.to(OutputStream, RDFFormat) instead.");
        ByteArrayOutputStream aOut = new ByteArrayOutputStream();
        RDFWriters.write(RDFWriters.to(aOut, theFormat).get(), theStatements, theNamespaces);
        return aOut.toString();
    }

    public static RDFWriterConfig to(OutputStream theStream) {
        return new RDFWriterConfig(theStream);
    }

    private RDFWriters() {
        throw new AssertionError();
    }

    static {
        ServiceLoaders.instancesOf(RDFWriterFactory.class).forEach(wf -> WRITERS.put(wf.format(), (RDFWriterFactory)wf));
        WRITERS.keySet().forEach(RDFFormats::register);
    }

    public static final class RDFWriterConfig {
        private OutputStream mOutputStream = ByteStreams.nullOutputStream();
        private boolean mGrouped = false;
        private RDFFormat mFormat = RDFFormats.NQUADS;
        private Options mOptions = WriterOptions.defaults();

        public RDFWriterConfig(@Nonnull OutputStream theOutputStream) {
            this.mOutputStream = theOutputStream;
        }

        @Nonnull
        public RDFWriterConfig to(@Nonnull OutputStream theStream) {
            this.mOutputStream = theStream;
            return this;
        }

        @Nonnull
        public RDFWriterConfig format(@Nonnull RDFFormat theFormat) {
            this.mFormat = theFormat;
            return this;
        }

        @Nonnull
        public RDFWriterConfig grouped(boolean theGrouped) {
            this.mGrouped = theGrouped;
            return this;
        }

        @Nonnull
        public <T> RDFWriterConfig set(@Nonnull Option<T> theOption, @Nullable T theValue) {
            this.mOptions.set(theOption, theValue);
            return this;
        }

        @Nonnull
        public RDFWriterConfig namespaces(@Nonnull Namespaces theNamespaces) {
            this.mOptions.set(WriterOptions.NAMESPACES, (Object)theNamespaces);
            return this;
        }

        public long write(@Nonnull Iterable<Statement> theStatements) {
            RDFWriter aWriter = RDFWriters.to(this.mOutputStream, this.mFormat, this.mOptions).orElseThrow(() -> new IllegalStateException("Unsupported RDF format provided"));
            if (this.mGrouped) {
                return RDFWriters.writeGrouped(aWriter, theStatements, (Iterable)this.mOptions.get(WriterOptions.NAMESPACES));
            }
            return RDFWriters.write(aWriter, theStatements);
        }
    }
}

