/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io;

import com.stardog.stark.Namespaces;
import com.stardog.stark.Statement;
import com.stardog.stark.impl.NamespacesImpl;
import com.stardog.stark.io.AbstractRDFHandler;
import com.stardog.stark.io.CollectingRDFHandler;
import com.stardog.stark.io.RDFHandler;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public final class RDFHandlers {
    public static CollectingRDFHandler<Set<Statement>> toSet() {
        LinkedHashSet aResult = new LinkedHashSet();
        return new CollectingRDFHandler<Set<Statement>>(aResult::add, () -> aResult);
    }

    public static GraphBuilder toGraph() {
        return new GraphBuilder();
    }

    public static RDFHandler consume(@Nonnull Consumer<Statement> theConsumer) {
        return new DefaultRDFHandler(theConsumer, (p, iri) -> {});
    }

    private RDFHandlers() {
        throw new AssertionError();
    }

    public static final class GraphBuilder
    extends AbstractRDFHandler {
        private final Set<Statement> mStatements = new HashSet<Statement>();
        private final NamespacesImpl mNamespaces = new NamespacesImpl();

        public Namespaces namespaces() {
            return this.mNamespaces;
        }

        public Set<Statement> graph() {
            return this.mStatements;
        }

        @Override
        public void namespace(@Nonnull String thePrefix, @Nonnull String theIRI) {
            this.mNamespaces.add(thePrefix, theIRI);
        }

        @Override
        public void handle(@Nonnull Statement theStmt) {
            this.mStatements.add(theStmt);
        }
    }

    public static final class DefaultRDFHandler
    extends AbstractRDFHandler {
        private final Consumer<Statement> mStmtHandler;
        private final BiConsumer<String, String> mNamespaceHandler;

        public DefaultRDFHandler(Consumer<Statement> theStmtHandler, BiConsumer<String, String> theNamespaceHandler) {
            this.mStmtHandler = theStmtHandler;
            this.mNamespaceHandler = theNamespaceHandler;
        }

        @Override
        public void handle(@Nonnull Statement theStmt) {
            this.mStmtHandler.accept(theStmt);
        }

        @Override
        public void namespace(@Nonnull String thePrefix, @Nonnull String theIRI) {
            this.mNamespaceHandler.accept(thePrefix, theIRI);
        }
    }
}

