/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.stardog.stark.IRI;
import com.stardog.stark.Values;
import com.stardog.stark.io.CompressedRDFFormat;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.FileFormatImpl;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFParsers;
import com.stardog.stark.io.RDFWriters;
import com.stardog.stark.io.SupportedFileFormats;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class RDFFormats {
    public static RDFFormat UNKNOWN_BASE_FORMAT = new RDFFormatImpl("", Values.iri((String)"urn:unknown"), (List<String>)ImmutableList.of((Object)""), (List<String>)ImmutableList.of((Object)""));
    private static final SupportedFileFormats<RDFFormat> FORMATS = new SupportedFileFormats();
    private static final SupportedFileFormats<RDFFormat> FORMATS_WITH_CONTEXT = new SupportedFileFormats();
    public static final RDFFormat TURTLE = new RDFFormatImpl("Turtle", Values.iri((String)"http://www.w3.org/ns/formats/Turtle"), (List<String>)ImmutableList.of((Object)"text/turtle", (Object)"application/x-turtle"), (List<String>)ImmutableList.of((Object)"ttl"));
    public static final RDFFormat PRETTY_TURTLE = new RDFFormatImpl("Pretty_Turtle", Values.iri((String)"http://www.w3.org/ns/formats/Turtle"), (List<String>)ImmutableList.of((Object)"text/turtle"), (List<String>)ImmutableList.of((Object)"ttl"));
    public static final RDFFormat NTRIPLES = new RDFFormatImpl("N-Triples", Values.iri((String)"http://www.w3.org/ns/formats/N-Triples"), (List<String>)ImmutableList.of((Object)"application/n-triples", (Object)"text/plain"), (List<String>)ImmutableList.of((Object)"nt"));
    public static final RDFFormat NQUADS = new RDFFormatImpl("N-Quads", Values.iri((String)"http://www.w3.org/ns/formats/N-Quads"), (List<String>)ImmutableList.of((Object)"application/n-quads", (Object)"text/x-nquads", (Object)"text/nquads"), (List<String>)ImmutableList.of((Object)"nq", (Object)"nquads"));
    public static final RDFFormat RDFXML = new RDFFormatImpl("RDF/XML", Values.iri((String)"http://www.w3.org/ns/formats/RDF_XML"), (List<String>)ImmutableList.of((Object)"application/rdf+xml", (Object)"application/xml", (Object)"text/xml"), (List<String>)ImmutableList.of((Object)"rdf", (Object)"rdfs", (Object)"owl", (Object)"xml", (Object)"rdfxml"));
    public static final RDFFormat N3 = new RDFFormatImpl("N3", Values.iri((String)"http://www.w3.org/ns/formats/N3"), (List<String>)ImmutableList.of((Object)"text/n3", (Object)"text/rdf+n3"), (List<String>)ImmutableList.of((Object)"n3"));
    public static final RDFFormat TRIG = new RDFFormatImpl("TriG", Values.iri((String)"http://www.w3.org/ns/formats/TriG"), (List<String>)ImmutableList.of((Object)"application/trig", (Object)"application/x-trig"), (List<String>)ImmutableList.of((Object)"trig"));
    public static final RDFFormat RDFJSON = new RDFFormatImpl("RDF/JSON", Values.iri((String)"http://www.w3.org/ns/formats/RDF_JSON"), (List<String>)ImmutableList.of((Object)"application/rdf+json"), (List<String>)ImmutableList.of((Object)"rj"));
    public static final RDFFormat BINARY = new BinaryRDFFormatImpl("BinaryRDF", Values.iri((String)"http://www.w3.org/ns/formats/BinaryRDF"), (List<String>)ImmutableList.of((Object)"application/x-binary-rdf"), (List<String>)ImmutableList.of((Object)"br"));
    public static final RDFFormat JSONLD = new RDFFormatImpl("JSON-LD", Values.iri((String)"http://www.w3.org/ns/formats/JSON-LD"), (List<String>)ImmutableList.of((Object)"application/ld+json"), (List<String>)ImmutableList.of((Object)"jsonld"));

    @Nonnull
    public static Optional<RDFFormat> forFile(@Nonnull Path thePath) {
        return Optional.ofNullable(RDFFormats.forFile(thePath.toString(), UNKNOWN_BASE_FORMAT)).filter(f -> f != UNKNOWN_BASE_FORMAT);
    }

    @Nonnull
    public static Optional<RDFFormat> forName(@Nonnull String theName) {
        return FORMATS.forName(theName);
    }

    @Nonnull
    public static Optional<RDFFormat> forMime(@Nonnull String theMime) {
        return FORMATS.only(f -> f != PRETTY_TURTLE).forMime(theMime);
    }

    @Nonnull
    public static RDFFormat compressedForName(RDFFormat theFormat, String theName) {
        if (theFormat instanceof CompressedRDFFormat) {
            return theFormat;
        }
        FileFormat.Compression aCompression = FileFormat.Compression.of(theName);
        if (aCompression == FileFormat.Compression.NONE) {
            return theFormat;
        }
        return RDFFormats.compressedFormat(theFormat, aCompression);
    }

    @Nonnull
    public static RDFFormat compressedFormat(RDFFormat theFormat, FileFormat.Compression theCompression) {
        if (theFormat != null) {
            return new CompressedRDFFormat(theFormat, theCompression);
        }
        if (theCompression.supportsUnknownBaseFormat()) {
            return new CompressedRDFFormat(UNKNOWN_BASE_FORMAT, theCompression);
        }
        throw new IllegalArgumentException("No base format specified for compression " + String.valueOf((Object)theCompression));
    }

    public static RDFFormat forFile(File theFile, RDFFormat theBaseFormat) {
        return RDFFormats.forFile(theFile.getName(), theBaseFormat);
    }

    public static Optional<RDFFormat> forFile(String theFileName) {
        return Optional.ofNullable(RDFFormats.forFile(theFileName, UNKNOWN_BASE_FORMAT));
    }

    public static RDFFormat forFile(String theFileName, RDFFormat theBaseFormat) {
        if (theFileName == null) {
            return theBaseFormat;
        }
        if (theFileName.endsWith(".json")) {
            return JSONLD;
        }
        if (theFileName.endsWith(".7z")) {
            return null;
        }
        if (theBaseFormat instanceof CompressedRDFFormat) {
            return theBaseFormat;
        }
        String aFileName = theFileName.toLowerCase();
        for (FileFormat.Compression aCompression : FileFormat.Compression.values()) {
            RDFFormat aBaseFormat;
            String aExt = aCompression.extension();
            if (aCompression == FileFormat.Compression.NONE || !aFileName.endsWith(aExt)) continue;
            aFileName = aFileName.substring(0, aFileName.length() - aExt.length());
            RDFFormat rDFFormat = aBaseFormat = theBaseFormat != null && theBaseFormat != UNKNOWN_BASE_FORMAT ? theBaseFormat : (RDFFormat)RDFFormats.forFile(Paths.get(aFileName, new String[0])).orElse(null);
            if (aBaseFormat == null) {
                if (aCompression.supportsUnknownBaseFormat()) {
                    aBaseFormat = UNKNOWN_BASE_FORMAT;
                } else {
                    return null;
                }
            }
            return new CompressedRDFFormat(aBaseFormat, aCompression);
        }
        return FORMATS.only(f -> f != PRETTY_TURTLE).forFile(Paths.get(theFileName, new String[0])).orElse(theBaseFormat);
    }

    public static RDFFormat baseFormat(RDFFormat theFormat) {
        return theFormat instanceof CompressedRDFFormat ? ((CompressedRDFFormat)theFormat).baseFormat() : theFormat;
    }

    @Nonnull
    public static FileFormat.Compression compressionOf(RDFFormat theFormat) {
        return theFormat instanceof CompressedRDFFormat ? ((CompressedRDFFormat)theFormat).compression() : FileFormat.Compression.NONE;
    }

    public static boolean supportsContexts(@Nonnull RDFFormat theFormat) {
        if (theFormat instanceof CompressedRDFFormat) {
            CompressedRDFFormat aCompressedFormat = (CompressedRDFFormat)theFormat;
            return aCompressedFormat.compression().supportsUnknownBaseFormat() || RDFFormats.supportsContexts(aCompressedFormat.baseFormat());
        }
        return FORMATS_WITH_CONTEXT.contains(theFormat) && FORMATS.contains(theFormat);
    }

    static void register(@Nonnull RDFFormat theFormat) {
        FORMATS.add(theFormat);
    }

    public static RDFFormat register(@Nonnull String theName, @Nonnull IRI theId, @Nonnull List<String> theMimetypes, @Nonnull List<String> theFileExtensions) {
        RDFFormatImpl aFormat = new RDFFormatImpl(theName, theId, theMimetypes, theFileExtensions);
        RDFFormats.register(aFormat);
        return aFormat;
    }

    public static RDFFormat.BinaryRDFFormat registerBinary(@Nonnull String theName, @Nonnull IRI theId, @Nonnull List<String> theMimetypes, @Nonnull List<String> theFileExtensions) {
        BinaryRDFFormatImpl aFormat = new BinaryRDFFormatImpl(theName, theId, theMimetypes, theFileExtensions);
        RDFFormats.register(aFormat);
        return aFormat;
    }

    private RDFFormats() {
        throw new AssertionError();
    }

    static {
        FORMATS.alias("RDFXML", RDFXML);
        FORMATS.alias("NQUADS", NQUADS);
        FORMATS.alias("NTRIPLES", NTRIPLES);
        FORMATS.alias("PRETTY", PRETTY_TURTLE);
        FORMATS.alias("JSONLD", JSONLD);
        RDFParsers.forFormat(RDFXML);
        RDFWriters.to(ByteStreams.nullOutputStream(), RDFXML);
        FORMATS_WITH_CONTEXT.add(JSONLD).add(BINARY).add(TRIG).add(NQUADS);
    }

    private static final class RDFFormatImpl
    extends FileFormatImpl
    implements RDFFormat {
        private final IRI mId;

        public RDFFormatImpl(@Nonnull String theName, @Nonnull IRI theId, @Nonnull List<String> theMimetypes, @Nonnull List<String> theFileExtensions) {
            super(theName, theMimetypes, theFileExtensions);
            this.mId = theId;
        }
    }

    private static final class BinaryRDFFormatImpl
    extends FileFormatImpl
    implements RDFFormat.BinaryRDFFormat {
        private final IRI mId;

        public BinaryRDFFormatImpl(@Nonnull String theName, @Nonnull IRI theId, @Nonnull List<String> theMimetypes, @Nonnull List<String> theFileExtensions) {
            super(theName, theMimetypes, theFileExtensions);
            this.mId = theId;
        }
    }
}

