/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io;

import com.complexible.common.base.Options;
import com.stardog.stark.io.IOParserContext;
import com.stardog.stark.io.LineBatch;
import com.stardog.stark.io.RDFHandler;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.commons.io.input.NullReader;

public class LineSupplierParserContext
extends IOParserContext {
    private final Supplier<LineBatch> input;
    private List<String> lines = Collections.emptyList();
    private String line = "";
    private int lineIndex = 0;
    private int charIndex = 0;
    private boolean newLineReturned = true;
    private boolean eof = false;

    public LineSupplierParserContext(@Nonnull Supplier<LineBatch> theInput, @Nonnull RDFHandler theHandler, @Nonnull Options theOptions) {
        super((Reader)new NullReader(0L), theHandler, theOptions);
        this.input = theInput;
    }

    @Override
    public int readCodePoint() throws IOException {
        if (this.charIndex >= this.line.length()) {
            if (this.newLineReturned) {
                this.readNextLine();
                if (this.eof) {
                    return -1;
                }
                if (this.line.isEmpty()) {
                    return 10;
                }
                this.newLineReturned = false;
            } else {
                this.newLineReturned = true;
                return 10;
            }
        }
        return this.line.charAt(this.charIndex++);
    }

    private void readNextLine() {
        if (++this.lineIndex >= this.lines.size()) {
            this.readNextBatch();
        } else {
            this.line = this.lines.get(this.lineIndex);
            this.charIndex = 0;
        }
    }

    private void readNextBatch() {
        if (this.eof) {
            return;
        }
        LineBatch nextBatch = this.input.get();
        this.mLineNumber = nextBatch.getLineNumber();
        this.lines = nextBatch.getLines();
        this.lineIndex = 0;
        this.charIndex = 0;
        this.eof = this.lines.isEmpty();
        this.line = this.eof ? "" : this.lines.get(this.lineIndex);
    }

    @Override
    public void unread(int theCodePoint) {
        if (this.newLineReturned) {
            assert (theCodePoint == 10);
            this.newLineReturned = false;
        } else {
            --this.charIndex;
            assert (this.charIndex >= 0 && this.line.charAt(this.charIndex) == theCodePoint);
        }
    }

    @Override
    public void unread(@Nonnull String theStr) {
        super.unread(theStr);
    }
}

