/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io;

import com.complexible.common.util.ServiceLoaders;
import com.stardog.stark.Datatype;
import com.stardog.stark.io.DatatypeHandler;
import com.stardog.stark.io.datatypes.RDFDatatypesHandler;
import com.stardog.stark.io.datatypes.XMLSchemaDatatypeHandler;
import javax.annotation.Nonnull;

final class DatatypeHandlers {
    private static final DatatypeHandler[] HANDLERS = (DatatypeHandler[])ServiceLoaders.instancesOf(DatatypeHandler.class).stream().filter(h -> !(h instanceof XMLSchemaDatatypeHandler)).toArray(DatatypeHandler[]::new);
    private static final XMLSchemaDatatypeHandler XSD_HANDLER = new XMLSchemaDatatypeHandler();
    private static final RDFDatatypesHandler RDF_DT_HANDLER = new RDFDatatypesHandler();

    static DatatypeHandler handlerFor(@Nonnull Datatype theType) {
        switch (theType) {
            case UDF: {
                for (DatatypeHandler aHandler : HANDLERS) {
                    if (!aHandler.isRecognizedDatatype(theType.iri())) continue;
                    return aHandler;
                }
                return null;
            }
            case LANG_STRING: {
                return RDF_DT_HANDLER;
            }
        }
        return XSD_HANDLER;
    }

    private DatatypeHandlers() {
        throw new AssertionError();
    }
}

