/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io;

import com.google.common.base.Preconditions;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.RDFFormat;
import java.nio.charset.Charset;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class CompressedRDFFormat
implements RDFFormat {
    private final RDFFormat mFormat;
    private final FileFormat.Compression mCompression;

    public CompressedRDFFormat(@Nonnull RDFFormat theFormat, @Nonnull FileFormat.Compression theCompression) {
        Preconditions.checkArgument((theCompression != FileFormat.Compression.NONE ? 1 : 0) != 0, (Object)"Compression cannot be NONE");
        this.mFormat = theFormat;
        this.mCompression = theCompression;
    }

    public String toString() {
        return String.valueOf((Object)this.mCompression) + " " + String.valueOf(this.mFormat);
    }

    @Nonnull
    public RDFFormat baseFormat() {
        return this.mFormat;
    }

    @Nonnull
    public FileFormat.Compression compression() {
        return this.mCompression;
    }

    @Override
    @Nonnull
    public String name() {
        return this.mFormat.name() + this.mCompression.extension();
    }

    @Override
    @Nonnull
    public Stream<String> mimeTypes() {
        return this.mFormat.mimeTypes();
    }

    @Override
    @Nonnull
    public Stream<String> extensions() {
        return this.mFormat.extensions();
    }

    @Override
    @Nonnull
    public String defaultMimeType() {
        return this.mFormat.defaultMimeType();
    }

    @Override
    @Nonnull
    public String defaultExtension() {
        return this.mFormat.defaultExtension();
    }

    @Override
    @Nonnull
    public Charset charset() {
        return this.mFormat.charset();
    }
}

