/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.jsonld;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;

final class JsonUtils {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final JsonFactory JSON_FACTORY = new JsonFactory((ObjectCodec)JSON_MAPPER);

    JsonUtils() {
    }

    public static JsonGenerator createGenerator(Writer writer) throws IOException {
        return JSON_FACTORY.createGenerator(writer);
    }

    public static void write(Writer writer, Object jsonObject) throws JsonGenerationException, IOException {
        JsonGenerator jw = JSON_FACTORY.createGenerator(writer);
        jw.writeObject(jsonObject);
    }

    public static void writePrettyPrint(Writer writer, Object jsonObject) throws JsonGenerationException, IOException {
        JsonGenerator jw = JSON_FACTORY.createGenerator(writer);
        jw.useDefaultPrettyPrinter();
        jw.writeObject(jsonObject);
    }

    public static Object fromInputStream(InputStream input, String enc) throws IOException {
        try (InputStreamReader in = new InputStreamReader(input, enc);){
            Object object;
            try (BufferedReader reader = new BufferedReader(in);){
                object = JsonUtils.fromReader(reader);
            }
            return object;
        }
    }

    public static Object fromReader(Reader reader) throws IOException {
        JsonToken t;
        Object rval;
        JsonParser jp = JSON_FACTORY.createParser(reader);
        JsonToken initialToken = jp.nextToken();
        if (initialToken == JsonToken.START_ARRAY) {
            rval = jp.readValueAs(List.class);
        } else if (initialToken == JsonToken.START_OBJECT) {
            rval = jp.readValueAs(Map.class);
        } else if (initialToken == JsonToken.VALUE_STRING) {
            rval = jp.readValueAs(String.class);
        } else if (initialToken == JsonToken.VALUE_FALSE || initialToken == JsonToken.VALUE_TRUE) {
            rval = jp.readValueAs(Boolean.class);
        } else if (initialToken == JsonToken.VALUE_NUMBER_FLOAT || initialToken == JsonToken.VALUE_NUMBER_INT) {
            rval = jp.readValueAs(Number.class);
        } else if (initialToken == JsonToken.VALUE_NULL) {
            rval = null;
        } else {
            throw new JsonParseException(jp, "document doesn't start with a valid json element : " + String.valueOf(initialToken), jp.getCurrentLocation());
        }
        try {
            t = jp.nextToken();
        }
        catch (JsonParseException ex) {
            throw new JsonParseException(jp, "Document contains more content after json-ld element - (possible mismatched {}?)", jp.getCurrentLocation());
        }
        if (t != null) {
            throw new JsonParseException(jp, "Document contains possible json content after the json-ld element - (possible mismatched {}?)", jp.getCurrentLocation());
        }
        return rval;
    }

    static {
        JSON_FACTORY.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        JSON_FACTORY.disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
        JSON_FACTORY.disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
    }
}

