/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.jsonld;

import com.complexible.common.base.Options;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RDFParser;
import com.github.jsonldjava.utils.Obj;
import com.google.common.base.Charsets;
import com.google.common.collect.Queues;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.AbstractRDFHandler;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFHandlerException;
import com.stardog.stark.io.RDFHandlers;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriterFactory;
import com.stardog.stark.io.WriterOptions;
import com.stardog.stark.io.WritingFailed;
import com.stardog.stark.io.jsonld.JSONLDMode;
import com.stardog.stark.io.jsonld.JSONLDOptions;
import com.stardog.stark.io.jsonld.JsonUtils;
import com.stardog.stark.io.turtle.TurtleParser;
import com.stardog.stark.io.turtle.TurtleWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

@Deprecated
public final class JSONLDWriter
implements RDFWriter {
    private final Options mOptions;
    private final Writer mWriter;
    private final RDFHandlers.GraphBuilder mGraph = RDFHandlers.toGraph();
    private boolean mEdgePropertyExists;
    private static final Pattern PATTERN_INTEGER = Pattern.compile("^[\\-+]?[0-9]+$");
    private static final Pattern PATTERN_DOUBLE = Pattern.compile("^(\\+|-)?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)([Ee](\\+|-)?[0-9]+)?$");

    public JSONLDWriter(@Nonnull OutputStream theStream, @Nonnull Options theOptions) {
        this.mOptions = theOptions;
        this.mWriter = new OutputStreamWriter(theStream, this.format().charset());
    }

    public void comment(@Nonnull String theComment) {
    }

    public void start() {
        this.mEdgePropertyExists = false;
    }

    public void handle(@Nonnull Statement theStmt) {
        this.mGraph.handle(theStmt);
        if (theStmt.subject() instanceof Statement) {
            this.mEdgePropertyExists = true;
        }
    }

    public void namespace(@Nonnull String thePrefix, @Nonnull String theIRI) {
        this.mGraph.namespace(thePrefix, theIRI);
    }

    public void end() {
        try {
            Object output = JsonLdProcessor.fromRDF((Object)this.mGraph.graph(), (RDFParser)new Parser());
            JSONLDMode mode = (JSONLDMode)((Object)this.mOptions.get(JSONLDOptions.JSONLD_MODE));
            JsonLdOptions opts = new JsonLdOptions();
            opts.setUseRdfType((Boolean)this.mOptions.get(JSONLDOptions.USE_RDF_TYPE));
            opts.setUseNativeTypes((Boolean)this.mOptions.get(JSONLDOptions.USE_NATIVE_TYPES));
            if (mode == JSONLDMode.EXPAND) {
                output = JsonLdProcessor.expand((Object)output, (JsonLdOptions)opts);
            }
            Object inframe = null;
            if (mode == JSONLDMode.FLATTEN) {
                output = JsonLdProcessor.flatten((Object)output, inframe, (JsonLdOptions)opts);
            }
            if (mode == JSONLDMode.COMPACT) {
                LinkedHashMap ctx = new LinkedHashMap();
                this.mGraph.namespaces().forEach(ns -> ctx.put(ns.prefix(), ns.iri()));
                HashMap localCtx = new HashMap();
                localCtx.put("@context", ctx);
                output = JsonLdProcessor.compact((Object)output, localCtx, (JsonLdOptions)opts);
            }
            if (this.mEdgePropertyExists) {
                this.postProcessEdgeProperties(output);
            }
            if (((Boolean)this.mOptions.get(WriterOptions.PRETTY_PRINT)).booleanValue()) {
                JsonUtils.writePrettyPrint(this.mWriter, output);
            } else {
                JsonUtils.write(this.mWriter, output);
            }
        }
        catch (JsonLdError | IOException e) {
            throw new WritingFailed("Could not render JSONLD", e);
        }
    }

    private void postProcessEdgeProperties(Object obj) throws IOException {
        TurtleParser parser = new TurtleParser();
        ArrayDeque queue = Queues.newArrayDeque();
        queue.add(obj);
        while (!queue.isEmpty()) {
            obj = queue.remove();
            if (obj instanceof Map) {
                final Map map = (Map)obj;
                queue.addAll(map.values());
                String id = (String)map.get("@id");
                if (id == null || !id.startsWith("<<") || !id.endsWith(">>")) continue;
                byte[] bytes = id.substring(2, id.length() - 2).getBytes(Charsets.UTF_8);
                parser.parse((InputStream)new ByteArrayInputStream(bytes), (RDFHandler)new AbstractRDFHandler(){

                    public void handle(@Nonnull Statement stmt) {
                        RDFDataset.Node s = JSONLDWriter.this.toNode((Value)stmt.subject());
                        RDFDataset.Node o = JSONLDWriter.this.toNode(stmt.object());
                        try {
                            Map<String, Object> embeddedStmt = JSONLDWriter.this.toObject(s);
                            embeddedStmt.put(stmt.predicate().toString(), JSONLDWriter.this.toObject(o));
                            map.put("@id", embeddedStmt);
                        }
                        catch (JsonLdError e) {
                            throw new RDFHandlerException((Throwable)e);
                        }
                    }
                });
                continue;
            }
            if (!(obj instanceof List)) continue;
            queue.addAll((List)obj);
        }
    }

    private RDFDataset.Node toNode(Value value) {
        if (value instanceof IRI) {
            return new RDFDataset.IRI(value.toString());
        }
        if (value instanceof BNode) {
            return new RDFDataset.BlankNode(value.toString());
        }
        Literal literal = (Literal)value;
        String label = literal.label();
        return new RDFDataset.Literal(label, literal.datatypeIRI().toString(), (String)literal.lang().orElse(null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, Object> toObject(RDFDataset.Node node) throws JsonLdError {
        boolean useNativeTypes = (Boolean)this.mOptions.get(JSONLDOptions.USE_NATIVE_TYPES);
        if (node.isIRI() || node.isBlankNode()) {
            return Obj.newMap((String)"@id", (Object)node.getValue());
        }
        Map rval = Obj.newMap((String)"@value", (Object)node.getValue());
        if (node.getLanguage() != null) {
            rval.put("@language", node.getLanguage());
            return rval;
        } else {
            String type = node.getDatatype();
            String value = node.getValue();
            if (useNativeTypes) {
                if ("http://www.w3.org/2001/XMLSchema#string".equals(type)) return rval;
                if ("http://www.w3.org/2001/XMLSchema#boolean".equals(type)) {
                    if ("true".equals(value)) {
                        rval.put("@value", Boolean.TRUE);
                        return rval;
                    } else if ("false".equals(value)) {
                        rval.put("@value", Boolean.FALSE);
                        return rval;
                    } else {
                        rval.put("@type", type);
                    }
                    return rval;
                } else if ("http://www.w3.org/2001/XMLSchema#integer".equals(type) && PATTERN_INTEGER.matcher(value).matches() || "http://www.w3.org/2001/XMLSchema#double".equals(type) && PATTERN_DOUBLE.matcher(value).matches()) {
                    try {
                        Double d = Double.parseDouble(value);
                        if (Double.isNaN(d) || Double.isInfinite(d)) return rval;
                        if ("http://www.w3.org/2001/XMLSchema#integer".equals(type)) {
                            Integer i = d.intValue();
                            if (!i.toString().equals(value)) return rval;
                            rval.put("@value", i);
                            return rval;
                        }
                        if (!"http://www.w3.org/2001/XMLSchema#double".equals(type)) throw new RuntimeException("This should never happen as we checked the type was either integer or double");
                        rval.put("@value", d);
                        return rval;
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    rval.put("@type", type);
                }
                return rval;
            } else {
                if ("http://www.w3.org/2001/XMLSchema#string".equals(type)) return rval;
                rval.put("@type", type);
            }
        }
        return rval;
    }

    @Nonnull
    public RDFFormat format() {
        return RDFFormats.JSONLD;
    }

    private static final class Parser
    implements RDFParser {
        private ResettableByteArrayOutputStream bytes = new ResettableByteArrayOutputStream();
        private TurtleWriter writer = new TurtleWriter((OutputStream)this.bytes, Options.create());

        private Parser() {
        }

        public void handle(RDFDataset theResult, Statement theStmt) {
            String graphName = Values.DEFAULT_GRAPH.equals((Object)theStmt.context()) ? "@default" : theStmt.context().toString();
            String subject = this.serialize(theStmt.subject());
            String predicate = theStmt.predicate().toString();
            Value object = theStmt.object();
            if (object instanceof Literal) {
                Literal literal = (Literal)object;
                String value = literal.label();
                theResult.addQuad(subject, predicate, value, literal.datatypeIRI().toString(), (String)literal.lang().orElse(null), graphName);
            } else {
                theResult.addQuad(subject, predicate, object.toString(), graphName);
            }
        }

        private String serialize(Resource res) {
            if (res instanceof Statement) {
                this.bytes.reset();
                this.writer.start();
                this.writer.handle((Statement)res);
                this.writer.end();
                return "<<" + new String(this.bytes.toByteArray(), Charsets.UTF_8).trim() + ">>";
            }
            return res.toString();
        }

        public RDFDataset parse(Object input) throws JsonLdError {
            RDFDataset aResult = new RDFDataset();
            if (input instanceof Statement) {
                this.handle(aResult, (Statement)input);
            } else if (input instanceof Iterable) {
                Iterable aStmts = (Iterable)input;
                aStmts.forEach(stmt -> this.handle(aResult, (Statement)stmt));
            }
            return aResult;
        }
    }

    public static final class JSONLDWriterFactory
    implements RDFWriterFactory {
        @Nonnull
        public RDFFormat format() {
            return RDFFormats.JSONLD;
        }

        @Nonnull
        public RDFWriter create(@Nonnull OutputStream theStream, @Nonnull Options theOptions) {
            return new JSONLDWriter(theStream, theOptions);
        }
    }

    private static final class ResettableByteArrayOutputStream
    extends ByteArrayOutputStream {
        private ResettableByteArrayOutputStream() {
        }

        @Override
        public final synchronized void reset() {
            this.count = 0;
        }
    }
}

