/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.jsonld;

import com.complexible.common.base.Options;
import com.fasterxml.jackson.core.JsonParseException;
import com.github.jsonldjava.core.DocumentLoader;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RemoteDocument;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.stardog.stark.BNode;
import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.IOParserContext;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.ParserOptions;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFParser;
import com.stardog.stark.io.jsonld.JsonUtils;
import com.stardog.stark.io.turtle.TurtleUtil;
import com.stardog.stark.util.ASCIIUtil;
import com.stardog.stark.vocabs.RDF;
import com.stardog.stark.vocabs.XSD;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JSONLDParser
implements RDFParser {
    @Nonnull
    public RDFFormat format() {
        return RDFFormats.JSONLD;
    }

    public void parse(@Nonnull InputStream theStream, @Nonnull RDFHandler theHandler, @Nonnull Options theOptions) throws IOException {
        JsonLdOptions aOpts = new JsonLdOptions((String)theOptions.get(ParserOptions.BASE_IRI));
        aOpts.useNamespaces = true;
        aOpts.setDocumentLoader(new DocumentLoader(this){

            public RemoteDocument loadDocument(String url) throws JsonLdError {
                return new RemoteDocument(url, (Object)ImmutableMap.of((Object)"@context", (Object)ImmutableMap.of()));
            }
        });
        try {
            JsonLdProcessor.toRDF((Object)JsonUtils.fromInputStream(theStream, Charsets.UTF_8.displayName()), (JsonLdTripleCallback)new Callback(theHandler, theOptions), (JsonLdOptions)aOpts);
        }
        catch (JsonLdError e) {
            throw new InvalidRDF("Could not parse JSONLD: " + e.getMessage(), -1L, -1L);
        }
        catch (JsonParseException e) {
            throw new InvalidRDF("Could not parse JSONLD: " + e.getMessage(), (long)e.getLocation().getLineNr(), (long)e.getLocation().getColumnNr());
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof InvalidRDF) {
                throw (InvalidRDF)e.getCause();
            }
            throw e;
        }
    }

    static {
        System.setProperty("com.github.jsonldjava.disallowRemoteContextLoading", "true");
    }

    private static final class Callback
    implements JsonLdTripleCallback {
        private final RDFHandler mHandler;
        private final IOParserContext mContext;

        Callback(RDFHandler theHandler, Options theOptions) {
            this.mHandler = theHandler;
            this.mContext = new IOParserContext((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), RDFFormats.JSONLD.charset()), this.mHandler, theOptions);
        }

        public Object call(RDFDataset theDataset) {
            this.mHandler.start();
            theDataset.getNamespaces().forEach((arg_0, arg_1) -> ((RDFHandler)this.mHandler).namespace(arg_0, arg_1));
            theDataset.keySet().stream().flatMap(g -> theDataset.getQuads(g).stream()).map(q -> Values.statement((Resource)this.resource(q.getSubject()), (IRI)this.iri(q.getPredicate()), (Value)this.value(q.getObject()), (Resource)this.context(Optional.ofNullable(q.getGraph()).map(RDFDataset.Node::getValue).orElse(null)))).forEach(arg_0 -> ((RDFHandler)this.mHandler).handle(arg_0));
            this.mHandler.end();
            return null;
        }

        private Resource context(String g) {
            if ("@default".equals(g)) {
                return Values.DEFAULT_GRAPH;
            }
            return this.resource(g);
        }

        private Literal literal(@Nonnull RDFDataset.Node theNode) {
            return this.mContext.createLiteral(theNode.getValue(), theNode.getLanguage(), (IRI)Optional.ofNullable(theNode.getDatatype()).map(Values::iri).orElse(null));
        }

        private Value value(@Nonnull RDFDataset.Node theNode) {
            if (theNode.isLiteral()) {
                return this.literal(theNode);
            }
            return this.resource(theNode);
        }

        private IRI iri(@Nonnull RDFDataset.Node theNode) {
            return Values.iri((String)theNode.getValue());
        }

        private Resource resource(@Nonnull RDFDataset.Node theNode) {
            return this.resource(theNode.getValue());
        }

        private Resource resource(@Nullable String resource) {
            if (resource == null) {
                return Values.DEFAULT_GRAPH;
            }
            if ("_:".equals(resource)) {
                return this.mContext.createBNode();
            }
            if (resource.startsWith("_:")) {
                return this.mContext.createBNode(resource.substring(2));
            }
            if (resource.startsWith("<<")) {
                try {
                    return this.parseEmbeddedTriple(resource);
                }
                catch (IOException e) {
                    throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.UNKNOWN_FORMAT, (Throwable)e));
                }
            }
            return Values.iri((String)resource);
        }

        private Statement parseEmbeddedTriple(String buffer) throws IOException {
            Preconditions.checkArgument((boolean)buffer.startsWith("<<"));
            Preconditions.checkArgument((boolean)buffer.endsWith(">>"));
            PushbackReader reader = new PushbackReader(new StringReader(buffer), 2);
            reader.read();
            reader.read();
            this.skipWS(reader);
            Resource subject = this.parseResource(reader);
            this.skipWS(reader);
            IRI predicate = this.parsePredicate(reader);
            this.skipWS(reader);
            Value object = this.parseValue(reader);
            this.skipWS(reader);
            reader.read();
            reader.read();
            return Values.statement((Resource)subject, (IRI)predicate, (Value)object);
        }

        private Resource parseResource(PushbackReader reader) throws IOException {
            Value value = this.parseValue(reader);
            if (value instanceof Resource) {
                return (Resource)value;
            }
            throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.UNKNOWN_FORMAT));
        }

        private IRI parsePredicate(PushbackReader reader) throws IOException {
            int c = reader.read();
            if (c == 97) {
                int c2 = reader.read();
                if (TurtleUtil.isWhitespace((int)c2)) {
                    return RDF.TYPE;
                }
                reader.unread(c2);
            }
            reader.unread(c);
            Value value = this.parseValue(reader);
            if (value instanceof IRI) {
                return (IRI)value;
            }
            throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.UNKNOWN_FORMAT));
        }

        private void skipWS(PushbackReader reader) throws IOException {
            int c = reader.read();
            while (TurtleUtil.isWhitespace((int)c) || c == 35) {
                if (c == 35) {
                    this.processComment(reader);
                }
                c = reader.read();
            }
            reader.unread(c);
        }

        private void processComment(PushbackReader reader) throws IOException {
            int c = reader.read();
            while (c != -1 && c != 13 && c != 10) {
                c = reader.read();
            }
            if (c == 13 && (c = reader.read()) != 10) {
                reader.unread(c);
            }
        }

        private Value parseValue(PushbackReader reader) throws IOException {
            int c = reader.read();
            reader.unread(c);
            if (c == 60) {
                return this.parseIRI(reader);
            }
            if (c == 58 || TurtleUtil.isPrefixStartChar((int)c)) {
                return this.parseQNameOrBoolean(reader);
            }
            if (c == 95) {
                return this.parseNodeID(reader);
            }
            if (c == 34 || c == 39) {
                return this.parseQuotedLiteral(reader);
            }
            if (ASCIIUtil.isNumber((int)c) || c == 46 || c == 43 || c == 45) {
                return this.parseNumber(reader);
            }
            if (c == -1) {
                throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.SYNTAX_ERROR));
            }
            return this.parseIRINoTokens(reader);
        }

        private void verifyCharacterOrFail(PushbackReader reader, int expected) throws IOException {
            if (reader.read() != expected) {
                throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.SYNTAX_ERROR));
            }
        }

        private void verifyCharacterOrFail(int c, int expected) {
            if (c != expected) {
                throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.SYNTAX_ERROR));
            }
        }

        private IRI parseIRI(PushbackReader reader) throws IOException {
            this.verifyCharacterOrFail(reader, 60);
            this.skipWS(reader);
            IRI result = this.parseIRINoTokens(reader);
            this.skipWS(reader);
            this.verifyCharacterOrFail(reader, 62);
            return result;
        }

        private IRI parseIRINoTokens(PushbackReader reader) throws IOException {
            StringBuilder buffer = new StringBuilder();
            int c = reader.read();
            while (c != 62 && c != 32) {
                if (c == -1) {
                    throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.UNKNOWN_FORMAT));
                }
                buffer.appendCodePoint(c);
                if (c == 92) {
                    c = reader.read();
                    if (c == -1) {
                        throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.UNKNOWN_FORMAT));
                    }
                    if (c != 117 && c != 85) {
                        throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.SYNTAX_ERROR));
                    }
                    buffer.appendCodePoint(c);
                }
                c = reader.read();
            }
            reader.unread(c);
            String uri = buffer.toString();
            uri = TurtleUtil.decodeString((String)uri);
            return this.mContext.resolveURI(uri);
        }

        protected Value parseQNameOrBoolean(PushbackReader reader) throws IOException {
            int previousChar;
            int c = reader.read();
            if (c == -1) {
                throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.UNKNOWN_FORMAT));
            }
            if (c != 58 && !TurtleUtil.isPrefixStartChar((int)c)) {
                throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.SYNTAX_ERROR, (Object)("Expected a ':' or a letter, found '" + (char)c + "'")));
            }
            String namespace = null;
            if (c == 58) {
                namespace = this.mContext.namespace("");
            } else {
                StringBuilder prefix = new StringBuilder();
                prefix.appendCodePoint(c);
                previousChar = c;
                c = reader.read();
                while (TurtleUtil.isPrefixChar((int)c)) {
                    prefix.appendCodePoint(c);
                    previousChar = c;
                    c = reader.read();
                }
                if (c != 58) {
                    String value = prefix.toString();
                    if (value.equals("true") || value.equals("false")) {
                        reader.unread(c);
                        return this.mContext.createLiteral(value, null, XSD.BOOLEAN);
                    }
                } else if (previousChar == 46) {
                    throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.SYNTAX_ERROR, (Object)"prefix can not end with with '.'"));
                }
                this.verifyCharacterOrFail(c, 58);
                namespace = prefix.toString();
            }
            StringBuilder localName = new StringBuilder();
            c = reader.read();
            if (TurtleUtil.isNameStartChar((int)c)) {
                if (c == 92) {
                    localName.append(this.readLocalEscapedChar(reader));
                } else {
                    localName.appendCodePoint(c);
                }
                previousChar = c;
                c = reader.read();
                while (TurtleUtil.isNameChar((int)c)) {
                    if (c == 92) {
                        localName.append(this.readLocalEscapedChar(reader));
                    } else {
                        localName.appendCodePoint(c);
                    }
                    previousChar = c;
                    c = reader.read();
                }
                reader.unread(c);
                if (previousChar == 46) {
                    reader.unread(previousChar);
                    localName.deleteCharAt(localName.length() - 1);
                }
            } else {
                reader.unread(c);
            }
            String localNameString = localName.toString();
            for (int i = 0; i < localNameString.length(); ++i) {
                if (localNameString.charAt(i) != '%' || i <= localNameString.length() - 3 && ASCIIUtil.isHex((int)localNameString.charAt(i + 1)) && ASCIIUtil.isHex((int)localNameString.charAt(i + 2))) continue;
                throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.SYNTAX_ERROR, (Object)("Found incomplete percent-encoded sequence: " + localNameString)));
            }
            return Values.iri((String)(namespace + ":" + localNameString));
        }

        private char readLocalEscapedChar(PushbackReader reader) throws IOException {
            int c = reader.read();
            if (TurtleUtil.isLocalEscapedChar((int)c)) {
                return (char)c;
            }
            throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.SYNTAX_ERROR, (Object)("Found '" + (char)c + "', expected one of: " + Arrays.toString(TurtleUtil.LOCAL_ESCAPED_CHARS))));
        }

        private BNode parseNodeID(PushbackReader reader) throws IOException {
            this.verifyCharacterOrFail(reader, 95);
            this.verifyCharacterOrFail(reader, 58);
            int c = reader.read();
            if (c == -1) {
                throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.UNKNOWN_FORMAT));
            }
            if (!TurtleUtil.isBLANK_NODE_LABEL_StartChar((int)c)) {
                throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.SYNTAX_ERROR, (Object)("Expected a letter, found '" + (char)c + "'")));
            }
            StringBuilder name = new StringBuilder();
            name.appendCodePoint(c);
            c = reader.read();
            if (!TurtleUtil.isBLANK_NODE_LABEL_Char((int)c)) {
                reader.unread(c);
            }
            while (TurtleUtil.isBLANK_NODE_LABEL_Char((int)c)) {
                int previous = c;
                c = reader.read();
                if (previous == 46 && (c == -1 || TurtleUtil.isWhitespace((int)c) || c == 60 || c == 95)) {
                    reader.unread(c);
                    reader.unread(previous);
                    break;
                }
                name.append((char)previous);
                if (TurtleUtil.isBLANK_NODE_LABEL_Char((int)c)) continue;
                reader.unread(c);
            }
            return this.mContext.createBNode(name.toString());
        }

        private Literal parseQuotedLiteral(PushbackReader reader) throws IOException {
            String label = this.parseQuotedString(reader);
            int c = reader.read();
            if (c == 64) {
                StringBuilder lang = new StringBuilder();
                c = reader.read();
                if (c == -1) {
                    throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.UNKNOWN_FORMAT));
                }
                lang.appendCodePoint(c);
                c = reader.read();
                while (!TurtleUtil.isWhitespace((int)c) && c != 46 && c != 59 && c != 44 && c != 41 && c != 93 && c != -1) {
                    lang.appendCodePoint(c);
                    c = reader.read();
                }
                reader.unread(c);
                return this.mContext.createLiteral(label, lang.toString(), null);
            }
            if (c == 94) {
                this.verifyCharacterOrFail(reader, 94);
                this.skipWS(reader);
                Value datatype = this.parseValue(reader);
                if (datatype instanceof IRI) {
                    return this.mContext.createLiteral(label, null, (IRI)datatype);
                }
                throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.UNKNOWN_FORMAT));
            }
            reader.unread(c);
            return Values.literal((String)label);
        }

        private String parseQuotedString(PushbackReader reader) throws IOException {
            String aResult = null;
            int c1 = reader.read();
            if (c1 != 34 && c1 != 39) {
                throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.SYNTAX_ERROR));
            }
            int c2 = reader.read();
            int c3 = reader.read();
            if (c1 == 34 && c2 == 34 && c3 == 34 || c1 == 39 && c2 == 39 && c3 == 39) {
                aResult = this.parseLongString(reader, c2);
            } else {
                reader.unread(c3);
                reader.unread(c2);
                aResult = this.parseString(reader, c1);
            }
            try {
                aResult = TurtleUtil.decodeString((String)aResult);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.SYNTAX_ERROR, (Object)"Invalid string encoding"));
            }
            return aResult;
        }

        private String parseString(PushbackReader reader, int closingCharacter) throws IOException {
            int c;
            StringBuilder buffer = new StringBuilder();
            while ((c = reader.read()) != closingCharacter) {
                if (c == -1) {
                    throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.UNKNOWN_FORMAT));
                }
                buffer.appendCodePoint(c);
                if (c != 92) continue;
                c = reader.read();
                if (c == -1) {
                    throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.UNKNOWN_FORMAT));
                }
                buffer.appendCodePoint(c);
            }
            return buffer.toString();
        }

        private String parseLongString(PushbackReader reader, int closingCharacter) throws IOException {
            StringBuilder buffer = new StringBuilder();
            int closingCharacterCount = 0;
            while (closingCharacterCount < 3) {
                int c = reader.read();
                if (c == -1) {
                    throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.UNKNOWN_FORMAT));
                }
                closingCharacterCount = c == closingCharacter ? ++closingCharacterCount : 0;
                buffer.appendCodePoint(c);
                if (c != 92) continue;
                c = reader.read();
                if (c == -1) {
                    throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.UNKNOWN_FORMAT));
                }
                buffer.appendCodePoint(c);
            }
            return buffer.substring(0, buffer.length() - 3);
        }

        protected Literal parseNumber(PushbackReader reader) throws IOException {
            StringBuilder value = new StringBuilder();
            Datatype datatype = Datatype.INTEGER;
            int c = reader.read();
            if (c == 43 || c == 45) {
                value.appendCodePoint(c);
                c = reader.read();
            }
            while (ASCIIUtil.isNumber((int)c)) {
                value.appendCodePoint(c);
                c = reader.read();
            }
            if (c == 46 || c == 101 || c == 69) {
                if (c == 46) {
                    int c2 = reader.read();
                    reader.unread(c2);
                    if (!TurtleUtil.isWhitespace((int)c2)) {
                        value.appendCodePoint(c);
                        c = reader.read();
                        while (ASCIIUtil.isNumber((int)c)) {
                            value.appendCodePoint(c);
                            c = reader.read();
                        }
                        if (value.length() == 1) {
                            throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.SYNTAX_ERROR));
                        }
                        datatype = Datatype.DECIMAL;
                    }
                } else if (value.length() == 0) {
                    throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.SYNTAX_ERROR));
                }
                if (c == 101 || c == 69) {
                    datatype = Datatype.DOUBLE;
                    value.appendCodePoint(c);
                    c = reader.read();
                    if (c == 43 || c == 45) {
                        value.appendCodePoint(c);
                        c = reader.read();
                    }
                    if (!ASCIIUtil.isNumber((int)c)) {
                        throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.SYNTAX_ERROR, (Object)"Exponent value missing"));
                    }
                    value.appendCodePoint(c);
                    c = reader.read();
                    while (ASCIIUtil.isNumber((int)c)) {
                        value.appendCodePoint(c);
                        c = reader.read();
                    }
                }
            }
            if (value.length() == 0) {
                throw new RuntimeException((Throwable)new JsonLdError(JsonLdError.Error.SYNTAX_ERROR, (Object)"Number expected but not found."));
            }
            reader.unread(c);
            return Values.literal((String)value.toString(), (Datatype)datatype);
        }
    }
}

