/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io.xml;

import com.complexible.common.base.Options;
import com.google.common.collect.ImmutableList;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.WriterOptions;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.QueryResultWriter;
import com.stardog.stark.query.io.QueryResultWriterFactory;
import com.stardog.stark.query.io.ResultWritingFailed;
import com.stardog.stark.query.io.SelectQueryResultWriter;
import com.stardog.stark.query.io.xml.AbstractSPARQLXMLWriter;
import com.stardog.stark.query.io.xml.SPARQLXMLConstants;
import com.stardog.stark.vocabs.XSD;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnull;

public final class SPARQLXMLSelectResultWriter
extends AbstractSPARQLXMLWriter<BindingSet>
implements SelectQueryResultWriter,
SPARQLXMLConstants {
    private List<String> mVars = ImmutableList.of();

    public SPARQLXMLSelectResultWriter(@Nonnull OutputStream theOutputStream, @Nonnull Options theOptions) {
        super(theOutputStream, theOptions);
    }

    public void variables(@Nonnull List<String> theVars) {
        if (!this.documentOpen) {
            this.start();
        }
        if (!this.headerOpen) {
            this.startHeader();
        }
        try {
            this.tupleVariablesFound = true;
            for (String name : theVars) {
                this.mWriter.setAttribute("name", name);
                this.mWriter.emptyElement("variable");
            }
            this.mVars = theVars;
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
    }

    public void handle(@Nonnull BindingSet theBindings) throws ResultWritingFailed {
        if (!this.documentOpen) {
            this.start();
        }
        if (!this.headerOpen) {
            this.startHeader();
        }
        if (!this.headerComplete) {
            this.endHeader();
        }
        if (!this.tupleVariablesFound) {
            throw new ResultWritingFailed("Cannot write results before projection variables have been written.");
        }
        try {
            this.mWriter.startTag("result");
            for (String var : this.mVars) {
                Value val = theBindings.get(var);
                if (val == null) continue;
                this.mWriter.setAttribute("name", var);
                this.mWriter.startTag("binding");
                this.writeValue(val);
                this.mWriter.endTag("binding");
            }
            this.mWriter.endTag("result");
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
    }

    @Nonnull
    public QueryResultFormat format() {
        return QueryResultFormats.XML;
    }

    private void writeValue(@Nonnull Value theValue) throws IOException {
        if (theValue instanceof IRI) {
            this.writeURI((IRI)theValue);
        } else if (theValue instanceof BNode) {
            this.writeBNode((BNode)theValue);
        } else if (theValue instanceof Literal) {
            this.writeLiteral((Literal)theValue);
        } else if (theValue instanceof Statement) {
            this.writeStatement((Statement)theValue);
        }
    }

    private void writeURI(@Nonnull IRI theIRI) throws IOException {
        this.mWriter.textElement("uri", theIRI.toString());
    }

    private void writeBNode(@Nonnull BNode theBNode) throws IOException {
        this.mWriter.textElement("bnode", theBNode.id());
    }

    private void writeStatement(@Nonnull Statement statement) throws IOException {
        this.mWriter.startTag("statement");
        this.mWriter.startTag("s");
        this.writeValue((Value)statement.subject());
        this.mWriter.endTag("s");
        this.mWriter.startTag("p");
        this.writeValue((Value)statement.predicate());
        this.mWriter.endTag("p");
        this.mWriter.startTag("o");
        this.writeValue(statement.object());
        this.mWriter.endTag("o");
        if (!Values.isDefaultGraph((Resource)statement.context())) {
            this.mWriter.startTag("g");
            this.writeValue((Value)statement.context());
            this.mWriter.endTag("g");
        }
        this.mWriter.endTag("statement");
    }

    private void writeLiteral(@Nonnull Literal theLiteral) throws IOException {
        if (Literal.isLanguageLiteral((Literal)theLiteral)) {
            this.mWriter.setAttribute("xml:lang", (String)theLiteral.lang().get());
        } else {
            boolean ignoreDatatype;
            IRI datatype = theLiteral.datatypeIRI();
            boolean bl = ignoreDatatype = datatype.equals((Object)XSD.STRING) && this.xsdStringToPlainLiteral();
            if (!ignoreDatatype) {
                this.mWriter.setAttribute("datatype", datatype.toString());
            }
        }
        this.mWriter.textElement("literal", theLiteral.label());
    }

    private boolean isQName(IRI nextUri) {
        return this.mNamespaces.prefix(nextUri.namespace()).isPresent();
    }

    private boolean xsdStringToPlainLiteral() {
        return (Boolean)this.mOptions.get(WriterOptions.XSD_STRING_TO_PLAIN_LITERAL);
    }

    public static final class SPARQLXMLSelectResultWriterFactory
    implements QueryResultWriterFactory {
        @Nonnull
        public QueryResultFormat format() {
            return QueryResultFormats.XML;
        }

        @Nonnull
        public QueryResultWriter<BindingSet> create(@Nonnull OutputStream theOutputStream, @Nonnull Options theOptions) {
            return new SPARQLXMLSelectResultWriter(theOutputStream, theOptions);
        }
    }
}

