/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io.xml;

import com.complexible.common.base.Options;
import com.complexible.common.io.XMLReaders;
import com.google.common.base.Throwables;
import com.stardog.stark.io.ParserOptions;
import com.stardog.stark.query.SelectQueryResultHandler;
import com.stardog.stark.query.io.InvalidQueryResults;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.SelectQueryResultParser;
import com.stardog.stark.query.io.xml.SAXErrorHandler;
import com.stardog.stark.query.io.xml.SPARQLResultsSAXParser;
import com.stardog.stark.query.io.xml.SimpleSAXParser;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class SPARQLXMLSelectResultParser
implements SelectQueryResultParser {
    @Nonnull
    public QueryResultFormat format() {
        return QueryResultFormats.XML;
    }

    public void parse(@Nonnull InputStream theStream, @Nonnull SelectQueryResultHandler theHandler, @Nonnull Options theOptions) throws IOException {
        try {
            XMLReader aReader = XMLReaders.createXMLReader((boolean)theOptions.is(ParserOptions.SECURE_PROCESSING));
            SimpleSAXParser aParser = new SimpleSAXParser(aReader);
            aReader.setErrorHandler(new SAXErrorHandler(theOptions, aParser));
            aParser.setPreserveWhitespace(true);
            aParser.setListener(new SPARQLResultsSAXParser(theHandler));
            aParser.parse(theStream);
        }
        catch (SAXParseException e) {
            throw new InvalidQueryResults(e.getMessage(), (long)e.getLineNumber(), (long)e.getColumnNumber());
        }
        catch (SAXException e) {
            if (e.getCause() != null) {
                Throwables.throwIfInstanceOf((Throwable)e.getCause(), InvalidQueryResults.class);
            }
            throw new InvalidQueryResults(e.getMessage(), -1L, -1L);
        }
    }
}

