/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io.xml;

import com.stardog.stark.query.QueryResultHandler;
import com.stardog.stark.query.io.InvalidQueryResults;
import com.stardog.stark.query.io.xml.SPARQLXMLConstants;
import com.stardog.stark.query.io.xml.SimpleSAXAdapter;
import java.util.Map;
import org.xml.sax.SAXException;

final class SPARQLBooleanResultsSAXParser
extends SimpleSAXAdapter
implements SPARQLXMLConstants {
    private final QueryResultHandler<Boolean> mHandler;
    private boolean mSawResult = false;

    public SPARQLBooleanResultsSAXParser(QueryResultHandler<Boolean> theHandler) {
        this.mHandler = theHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startTag(String theTag, Map<String, String> theAtts, String theText) throws SAXException {
        if ("boolean".equals(theTag)) {
            this.mSawResult = true;
            if ("true".equalsIgnoreCase(theText)) {
                this.mHandler.handle((Object)true);
                return;
            } else {
                if (!"false".equalsIgnoreCase(theText)) throw new SAXException("Illegal value for element boolean: " + theText);
                this.mHandler.handle((Object)false);
            }
            return;
        } else {
            if (!"results".equals(theTag) && !"result".equals(theTag)) return;
            throw new SAXException((Exception)new InvalidQueryResults("Found tuple results in boolean parser"));
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (!this.mSawResult) {
            throw new SAXException("Malformed document, boolean element not found");
        }
    }
}

