/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.protobuf.io;

import com.complexible.common.io.ForwardingDataInput;
import com.complexible.common.io.ForwardingDataOutput;
import com.complexible.common.protobuf.io.ProtobufDataInput;
import com.complexible.common.protobuf.io.ProtobufDataOutput;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Protobuf {
    private Protobuf() {
        throw new AssertionError();
    }

    public static <T extends MessageLite> List<T> decodeList(CodedInputStream theCodeStream, T thePrototype) throws IOException {
        int aCount = Protobuf.readBigEndianInt32(theCodeStream);
        MessageLite.Builder aBuilder = thePrototype.newBuilderForType();
        ArrayList aList = Lists.newArrayList();
        for (int i = 0; i < aCount; ++i) {
            aBuilder.clear();
            int aSize = theCodeStream.readRawVarint32();
            aBuilder.mergeFrom(theCodeStream.readRawBytes(aSize));
            aList.add(aBuilder.build());
        }
        return aList;
    }

    private static int readBigEndianInt32(CodedInputStream theCodeStream) throws IOException {
        byte one = theCodeStream.readRawByte();
        byte two = theCodeStream.readRawByte();
        byte three = theCodeStream.readRawByte();
        byte four = theCodeStream.readRawByte();
        return Ints.fromBytes((byte)one, (byte)two, (byte)three, (byte)four);
    }

    public static <T extends MessageLite> T parseDelimitedFrom(ByteString theBytes, T thePrototype) throws IOException {
        MessageLite.Builder aBuilder = thePrototype.getDefaultInstanceForType().newBuilderForType();
        if (aBuilder.mergeDelimitedFrom(theBytes.newInput())) {
            return (T)aBuilder.build();
        }
        return null;
    }

    public static int readRawVarint32(DataInput theInput) throws IOException {
        byte tmp = theInput.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = theInput.readByte();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = theInput.readByte();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = theInput.readByte();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = theInput.readByte();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (theInput.readByte() < 0) continue;
                            return result;
                        }
                        throw new IOException("malformedVarint32");
                    }
                }
            }
        }
        return result;
    }

    public static long readRawVarint64(DataInput theInput) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = theInput.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IOException("malformedVarint64");
    }

    public static void writeRawVarint32(DataOutput theOutput, int theValue) throws IOException {
        while (true) {
            if ((theValue & 0xFFFFFF80) == 0) {
                theOutput.writeByte(theValue);
                return;
            }
            theOutput.writeByte(theValue & 0x7F | 0x80);
            theValue >>>= 7;
        }
    }

    public static void writeRawVarint64(DataOutput theOutput, long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                theOutput.writeByte((int)value);
                return;
            }
            theOutput.writeByte((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static final ProtobufDataOutput outputFor(DataOutput theOutput) {
        return new ProtobufDataOutputImpl(theOutput);
    }

    public static <T extends MessageLite> ProtobufDataInput<T> inputFor(DataInput theInput, T thePrototype, ExtensionRegistry theExtensionRegistry) {
        return new ProtobufDataInputImpl(theInput, thePrototype, theExtensionRegistry, null);
    }

    static class 1 {
    }

    private static final class ProtobufDataInputImpl<T extends MessageLite>
    extends ForwardingDataInput
    implements ProtobufDataInput<T> {
        private final ExtensionRegistry mExtensionRegistry;
        private final T mPrototype;

        private ProtobufDataInputImpl(DataInput theInput, T thePrototype, ExtensionRegistry theExtensionRegistry) {
            super(theInput);
            this.mPrototype = thePrototype;
            this.mExtensionRegistry = theExtensionRegistry;
        }

        @Override
        public T read() throws InvalidProtocolBufferException, IOException {
            try {
                int aSize = this.readInt();
                byte[] aData = new byte[aSize];
                this.readFully(aData);
                if (this.mExtensionRegistry == null) {
                    return (T)this.mPrototype.newBuilderForType().mergeFrom(aData).build();
                }
                return (T)this.mPrototype.newBuilderForType().mergeFrom(aData, (ExtensionRegistryLite)this.mExtensionRegistry).build();
            }
            catch (EOFException e) {
                return null;
            }
        }

        /* synthetic */ ProtobufDataInputImpl(DataInput x0, MessageLite x1, ExtensionRegistry x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    private static final class ProtobufDataOutputImpl
    extends ForwardingDataOutput
    implements ProtobufDataOutput {
        public ProtobufDataOutputImpl(DataOutput theOutput) {
            super(theOutput);
        }

        @Override
        public void write(MessageLite theMessage) throws IOException {
            byte[] aBytes = theMessage.toByteArray();
            this.writeInt(aBytes.length);
            this.write(aBytes);
        }
    }
}

